extern "C" {
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <netdb.h>
}

int main(int argc, char **argv) 
{  
	int		sock, n;
	struct addrinfo	hints, *res, *ressave;
	int longueurAdr;
	struct sockaddr *adrDest;

	// Rcupration de l'adresse de destination (@IP+port)
	bzero(&hints, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC; // le systme choisira IPv4 ou IPv6
	hints.ai_socktype = SOCK_DGRAM; // on veut UDP
	//  la place de localhost on peut mettre le nom de la machine
	// ou son adresse IP (v4 ou v6)
	if ( (n = getaddrinfo("localhost", "13214", &hints, &res)) != 0) {
		printf("erreur getaddrinfo : %s\n", gai_strerror(n));
		return 1;
	}
	ressave = res;

	do { // Construction d'un socket compatible avec cette adresse
		sock = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
		if (sock >= 0)
			break;		// a a march
	} while ( (res = res->ai_next) != NULL);

	// aucune adresse n'a fonctionn, errno est positionn par socket()
	if (res == NULL) {
		perror("erreur socket");
		return 1;
	}

	// on alloue puis on recopie l'adresse IP + port de destination
	adrDest = (struct sockaddr*)malloc(res->ai_addrlen);
	memcpy(adrDest, res->ai_addr, res->ai_addrlen);
	longueurAdr = res->ai_addrlen;
	// on libre la mmoire alloue par getaddrinfo
	freeaddrinfo(ressave);
	
	#define BUFFERLEN 256                            
	char buf[BUFFERLEN];        // Tampon pour le message
	sprintf(buf, "bonjour !");  // On crit le message dans le tampon
		
	// Envoie le message 
	if (sendto(sock, buf, strlen(buf) + 1, 0, adrDest, longueurAdr) <0) {
		  perror("sendto");
		  return 1;
	}
	
    return 0;
 }
