#include <stdio.h>

#include <winsock2.h>

#include <time.h>

/* Variables caches */

/* le socket */
SOCKET	physique_socket;
/* les timers */
/* timers[0] contiens le nombre de timers */
int	physique_timers[100];

int	physique_initialise = 0;

/* proba de perte */
float	physique_proba_perte = 0;
/* nom de la machine destination */
char*	physique_destination = NULL;
short	physique_port_local = 2000;
short	physique_port_destination = 2000;

/* initialisation avec un taux de perte */
void Initialisation(float proba_perte, short port_local, char* destination, short port_destination) {
	struct sockaddr_in adresse_locale;
	WSADATA	wsaData;

	physique_initialise = 1;

	physique_proba_perte = proba_perte;
	physique_destination = strdup(destination);
	physique_port_local = port_local;
	physique_port_destination = port_destination;

	srand( (unsigned)time( NULL ) );

	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR)
	{
		printf("WSAStartup() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
		WSACleanup();
		exit(1);
	}

	physique_socket = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (physique_socket < 0)
	{
		printf("socket() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
		WSACleanup();
		exit(1);
	}

	adresse_locale.sin_port        = htons(physique_port_local);
	adresse_locale.sin_family      = AF_INET;
	adresse_locale.sin_addr.s_addr = INADDR_ANY;

	if (bind(physique_socket, (struct sockaddr *)&adresse_locale, sizeof(adresse_locale)) < 0)
	{
		printf("bind() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
		WSACleanup();
		exit(1);
	}

	physique_timers[0] = 0;
}

/* Attends un vnement et retourne soit 0 si un
paquet reu est disponible ou un numro de timer
si un timeout a t gnr */
int Attendre() {
	struct fd_set read_fs;
	struct timeval timeout;
	struct timeval *ptimeout;
	int rep;
	int fini = 0;
	int i;
	int resultat = -1;

	if (!physique_initialise)
		Initialisation(0, 2000, "localhost", 2000);

	rep = 0;
	for(i=1; i < physique_timers[0]; i++)
	{
		if(physique_timers[i]>0)
			rep = i;
	}
	if (rep>0)
	{
		timeout.tv_sec = 0;
		timeout.tv_usec = 100000; /* 100000 us = 100 ms */
		ptimeout = &timeout;
	}
	else 
		ptimeout = NULL;

	while(!fini)
	{
		FD_ZERO(&read_fs);
		FD_SET(physique_socket, &read_fs);
		rep = select(1, &read_fs, NULL, NULL, ptimeout);

		if(rep < 0)
		{
			printf("select() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
			WSACleanup();
			exit(1);
		} 
		else if(rep == 0)
		{
			/* timeout ? */
			for(i=1; i < physique_timers[0]; i++)
			{
				if (physique_timers[i] > 0 && physique_timers[i] <= 100)
				{
					fini = 1;
					resultat = i;
					physique_timers[i] = -1;
				}
				else if (physique_timers[i] > 0)	
					physique_timers[i] -= 100;
			}
		}
		else 
		{
			/* reception possible */
			fini = 1;
			resultat = 0;
		}
	}

	return resultat;
}

/* reoit une trame */
void DeCanal(char trame[]) {
	int l_data;
	if (!physique_initialise)
		Initialisation(0, 2000, "localhost", 2000);

	l_data = recvfrom(physique_socket, trame, 100, 0, NULL, NULL);
	if (l_data < 0) {
		printf("recvfrom() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
		WSACleanup();
		exit(1);
	}
	//printf("trame de longueur %d recue\n", l_data);
}

/* envoit une trame */
void VersCanal(char trame[]) {
	struct hostent *host;
	struct sockaddr_in adresse_dest;
	int l_adr = sizeof(adresse_dest);
	int l_data;

	if (!physique_initialise)
		Initialisation(0, 2000, "localhost", 2000);

	/* perte ? */
	

	if(rand()/(float)RAND_MAX < physique_proba_perte) {
		printf("perte de trame\n");
		return;
	}
	/* calcul de l'adresse de destination */
	host = gethostbyname(physique_destination);

	if (host == NULL)
	{
		printf("gethostbyname() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
		WSACleanup();
		exit(1);
	}

	memcpy((void *)&(adresse_dest.sin_addr), (void *)host->h_addr, host->h_length);
	
	adresse_dest.sin_port        = htons(physique_port_destination);
	adresse_dest.sin_family      = AF_INET;
	
	l_data = sendto(physique_socket, trame, 100, 0, (struct sockaddr *)&adresse_dest, l_adr);
	if (l_data < 0) {
		printf("sendto() n'a pas fonctionne, erreur : %d\n", WSAGetLastError()) ;
		WSACleanup();
		exit(1);
	}
	printf("trame de longueur %d envoye\n", l_data);
}

/* dmarre le timer numro n (0 < n < 100) qui s'arrte
aprs ms millisecondes (ms doit tre un multiple de 100) */
void DepartCompteur(int n, int ms) {
	physique_timers[n] = ms;
	if (n+1 > physique_timers[0])
	{
		physique_timers[0] = n+1;
	}
}

/* arrte le timer numro n */
void ArreterCompteur(int n) {
	physique_timers[n] = -1;

	if (n+1 == physique_timers[0])
	{
		physique_timers[0] = n;
	}
}

