/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.vm;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.security.Principal;
import org.exolab.jms.common.uuid.UUIDGenerator;
import org.exolab.jms.net.connector.AbstractManagedConnection;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerImpl;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.IllegalStateException;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnectionListener;
import org.exolab.jms.net.connector.MarshalledInvocation;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.connector.URIRequestInfo;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;
import org.exolab.jms.net.vm.VMConnection;
import org.exolab.jms.net.vm.VMInvoker;
import org.exolab.jms.net.vm.VMManagedConnectionAcceptor;

class VMManagedConnection
extends AbstractManagedConnection {
    private VMInvoker _remoteInvoker;
    private InvocationHandler _invoker;
    private URI _remoteURI;
    private URI _localURI;
    private Principal _principal;
    private Caller _caller;

    protected VMManagedConnection(Principal principal, URIRequestInfo info) throws ResourceException {
        this._remoteURI = info.getURI();
        try {
            this._localURI = URIHelper.create("vm", null, -1, UUIDGenerator.create());
        }
        catch (InvalidURIException exception) {
            throw new ResourceException("Failed to generate local URI", exception);
        }
        VMInvoker invoker = new VMInvoker(this);
        this._remoteInvoker = VMManagedConnectionAcceptor.connect(principal, info, invoker, this._localURI);
        this._principal = principal;
    }

    protected VMManagedConnection(Principal principal, URIRequestInfo info, VMInvoker client, URI uri) {
        this._localURI = info.getURI();
        this._remoteInvoker = client;
        this._remoteURI = uri;
        this._caller = new CallerImpl(this._remoteURI, this._localURI);
        this._principal = principal;
    }

    public synchronized Connection getConnection() throws IllegalStateException {
        if (this._invoker == null) {
            throw new IllegalStateException("No InvocationHandler registered");
        }
        return new VMConnection(this);
    }

    public synchronized void setInvocationHandler(InvocationHandler handler) throws ResourceException {
        if (this._invoker != null) {
            throw new IllegalStateException("An invocation handler is already registered");
        }
        this._invoker = handler;
    }

    public void ping() throws ResourceException {
        ManagedConnectionListener listener;
        VMInvoker invoker;
        VMManagedConnection vMManagedConnection = this;
        synchronized (vMManagedConnection) {
            invoker = this._remoteInvoker;
        }
        if (invoker == null) {
            throw new IllegalStateException("No connection");
        }
        if (invoker.isAlive() && (listener = this.getConnectionEventListener()) != null) {
            listener.pinged(this);
        }
    }

    public void destroy() throws ResourceException {
        VMInvoker invoker;
        VMManagedConnection vMManagedConnection = this;
        synchronized (vMManagedConnection) {
            invoker = this._remoteInvoker;
            this._remoteInvoker = null;
        }
        if (invoker != null) {
            invoker.destroy();
        }
    }

    public URI getRemoteURI() {
        return this._remoteURI;
    }

    public URI getLocalURI() {
        return this._localURI;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean hasPrincipal(Principal principal) {
        boolean result = false;
        if (this._principal != null && this._principal.equals(principal) || this._principal == null && principal == null) {
            result = true;
        }
        return result;
    }

    protected Response invoke(Connection connection, Request request) {
        Response response;
        try {
            MarshalledObject<Request> wrappedRequest = new MarshalledObject<Request>(request);
            MarshalledObject wrappedResponse = this._remoteInvoker.invoke(wrappedRequest);
            response = (Response)wrappedResponse.get();
        }
        catch (ClassNotFoundException exception) {
            response = new Response(exception);
        }
        catch (IOException exception) {
            response = new Response(exception);
        }
        return response;
    }

    protected MarshalledObject invokeLocal(MarshalledObject request) throws MarshalException {
        MarshalledObject response;
        MarshalledInvocation invocation = new MarshalledInvocation(request, this._caller);
        this._invoker.invoke(invocation);
        try {
            response = invocation.getMarshalledResponse();
        }
        catch (Exception exception) {
            throw new MarshalException("Failed to marshal response", exception);
        }
        return response;
    }

    protected boolean isAliveLocal() {
        boolean alive;
        VMManagedConnection vMManagedConnection = this;
        synchronized (vMManagedConnection) {
            alive = this._remoteInvoker != null;
        }
        return alive;
    }

    protected void destroyLocal() throws ResourceException {
        VMManagedConnection vMManagedConnection = this;
        synchronized (vMManagedConnection) {
            this._remoteInvoker = null;
        }
        ManagedConnectionListener listener = this.getConnectionEventListener();
        if (listener != null) {
            listener.closed(this);
        }
    }
}

