/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.util;

import java.util.Properties;
import org.exolab.jms.net.util.SSLProperties;

public class SSLHelper {
    public static final String KEY_STORE = "javax.net.ssl.keyStore";
    public static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";

    public static void configure(SSLProperties properties) throws SecurityException {
        SSLHelper.update(KEY_STORE, properties.getKeyStore());
        SSLHelper.update(KEY_STORE_PASSWORD, properties.getKeyStorePassword());
        SSLHelper.update(KEY_STORE_TYPE, properties.getKeyStoreType());
        SSLHelper.update(TRUST_STORE, properties.getTrustStore());
        SSLHelper.update(TRUST_STORE_PASSWORD, properties.getTrustStorePassword());
        SSLHelper.update(TRUST_STORE_TYPE, properties.getTrustStoreType());
    }

    private static void update(String key, String value) throws SecurityException {
        if (value != null) {
            System.setProperty(key, value);
        } else if (System.getProperty(key) != null) {
            Properties properties = System.getProperties();
            properties.remove(key);
        }
    }
}

