/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.util;

import java.util.HashMap;
import java.util.Map;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public final class Properties {
    private final Map _properties;
    private final String _prefix;

    public Properties(String prefix) {
        this(null, prefix);
    }

    public Properties(Map properties, String prefix) {
        this._properties = properties != null ? properties : new HashMap();
        this._prefix = prefix;
    }

    public void set(String name, String value) {
        this._properties.put(this.getName(name), value);
    }

    public void setNonNull(String name, String value) {
        if (value != null) {
            this._properties.put(this.getName(name), value);
        }
    }

    public void set(String name, boolean value) {
        Boolean bool = value ? Boolean.TRUE : Boolean.FALSE;
        this.set(name, bool.toString());
    }

    public void set(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public void set(String name, Object value) {
        if (value != null) {
            this.set(name, value.toString());
        } else {
            this.set(name, null);
        }
    }

    public void setNonNull(String name, Object value) {
        if (value != null) {
            this.set(name, value.toString());
        }
    }

    public String get(String name) throws ResourceException {
        Object result = null;
        result = this._properties.get(name = this.getName(name));
        if (result != null && !(result instanceof String)) {
            throw new ResourceException("Invalid type for property=" + name);
        }
        return result;
    }

    public boolean getBoolean(String name, boolean defaultValue) throws ResourceException {
        boolean result = defaultValue;
        String value = this.get(name);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            } else {
                throw new ResourceException("Invalid boolean for property=" + this.getName(name) + ": " + value);
            }
        }
        return result;
    }

    public int getInt(String name, int defaultValue) throws ResourceException {
        int result = defaultValue;
        String value = this.get(name);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                throw new ResourceException("Invalid int for property=" + this.getName(name) + ": " + value);
            }
        }
        return result;
    }

    public URI getURI(String name) throws ResourceException {
        URI result = null;
        String uri = this.get(name);
        if (uri != null) {
            try {
                result = URIHelper.parse(uri);
            }
            catch (InvalidURIException exception) {
                throw new ResourceException("Invalid URI for property=" + this.getName(name) + ": " + uri);
            }
        }
        return result;
    }

    public Map getProperties() {
        return this._properties;
    }

    private String getName(String name) {
        String result = this._prefix != null && name.indexOf(46) == -1 ? this._prefix + name : name;
        return result;
    }
}

