/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.uri;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.exolab.jms.common.security.BasicPrincipal;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;

public final class URIHelper {
    private URIHelper() {
    }

    public static URI create(String scheme, String host, int port) throws InvalidURIException {
        return URIHelper.create(scheme, host, port, "/");
    }

    public static URI create(String scheme, String host, int port, String path) throws InvalidURIException {
        URI result;
        try {
            result = new URI(scheme, null, host, port, path, null, null);
        }
        catch (URI.MalformedURIException exception) {
            throw new InvalidURIException(exception.getMessage());
        }
        return result;
    }

    public static URI create(String scheme, String host, int port, String path, Map params) throws InvalidURIException {
        Iterator iter = params.entrySet().iterator();
        StringBuffer query = new StringBuffer();
        int i = 0;
        while (iter.hasNext()) {
            if (i > 0) {
                query.append('&');
            }
            Map.Entry entry = iter.next();
            query.append(entry.getKey());
            query.append('=');
            query.append(entry.getValue());
            ++i;
        }
        return URIHelper.create(scheme, host, port, path, query.toString());
    }

    public static URI create(String scheme, String host, int port, String path, String query) throws InvalidURIException {
        URI result;
        try {
            result = new URI(scheme, null, host, port, path, query, null);
        }
        catch (URI.MalformedURIException exception) {
            throw new InvalidURIException(exception.getMessage());
        }
        return result;
    }

    public static URI parse(String uri) throws InvalidURIException {
        URI result;
        try {
            result = new URI(uri);
            URIHelper.fixPath(result);
        }
        catch (URI.MalformedURIException exception) {
            throw new InvalidURIException(exception.getMessage());
        }
        return result;
    }

    public static URI parse(String uri, String scheme) throws InvalidURIException {
        URI result = URIHelper.parse(uri);
        if (!result.getScheme().equals(scheme)) {
            throw new InvalidURIException("Invalid scheme: " + result.getScheme());
        }
        return result;
    }

    public static URI parseHostPort(String uri, String scheme) throws InvalidURIException {
        URI result = URIHelper.parse(uri, scheme);
        if (result.getHost() == null) {
            throw new InvalidURIException("No host specified in URI: " + uri);
        }
        if (result.getPort() == -1) {
            throw new InvalidURIException("No port specified in URI: " + uri);
        }
        if (result.getPath() != null && !result.getPath().equals("") && !result.getPath().equals("/")) {
            throw new InvalidURIException("URI must not specify a path: " + uri);
        }
        return result;
    }

    public static URI convertHostToAddress(URI uri) {
        URI result = uri;
        String host = uri.getHost();
        if (host != null && !host.equals("")) {
            try {
                InetAddress address = InetAddress.getByName(host);
                result = new URI(uri.getScheme(), uri.getUserinfo(), address.getHostAddress(), uri.getPort(), uri.getPath(), uri.getQueryString(), uri.getFragment());
                URIHelper.fixPath(result);
            }
            catch (UnknownHostException ignore) {
            }
            catch (URI.MalformedURIException exception) {
                throw new IllegalArgumentException("Failed to construct URI: " + exception.getMessage());
            }
        }
        return result;
    }

    public static BasicPrincipal getPrincipal(URI uri) {
        BasicPrincipal principal = null;
        String userinfo = uri.getUserinfo();
        if (userinfo != null && userinfo.length() != 0) {
            String user;
            int index = userinfo.indexOf(":");
            String password = "";
            if (index != -1) {
                user = userinfo.substring(0, index);
                password = userinfo.substring(index + 1);
            } else {
                user = userinfo;
            }
            principal = new BasicPrincipal(user, password);
        }
        return principal;
    }

    public static URI getURISansQuery(URI uri) {
        URI result = uri;
        if (uri.getQueryString() != null || uri.getFragment() != null) {
            try {
                result = new URI(uri.getScheme(), uri.getUserinfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
            }
            catch (URI.MalformedURIException exception) {
                throw new IllegalArgumentException("Failed to construct URI: " + exception.getMessage());
            }
        }
        return result;
    }

    public static Map parseQuery(String query) throws InvalidURIException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(query, "&");
        while (tokens.hasMoreTokens()) {
            String pair = tokens.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new InvalidURIException("Invalid query=" + query);
            }
            String key = pair.substring(0, pos);
            String value = pair.substring(pos + 1, pair.length());
            result.put(key, value);
        }
        return result;
    }

    private static void fixPath(URI uri) throws URI.MalformedURIException {
        String path = uri.getPath();
        if (path == null || path.equals("")) {
            uri.setPath("/");
        }
    }
}

