/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.uri;

import java.io.IOException;

public final class URI {
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,";
    private static final String MARK_CHARACTERS = "-_.!~*'() ";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private String _scheme = null;
    private String _userinfo = null;
    private String _host = null;
    private int _port = -1;
    private String _path = null;
    private String _queryString = null;
    private String _fragment = null;
    private static boolean DEBUG = false;

    public URI() {
    }

    public URI(URI other) {
        this.initialize(other);
    }

    public URI(String uriSpec) throws MalformedURIException {
        this((URI)null, uriSpec);
    }

    public URI(URI base, String uriSpec) throws MalformedURIException {
        this.initialize(base, uriSpec);
    }

    public URI(String scheme, String schemeSpecificPart) throws MalformedURIException {
        if (scheme == null || scheme.trim().length() == 0) {
            throw new MalformedURIException("Argument scheme is null or an empty string");
        }
        if (schemeSpecificPart == null || schemeSpecificPart.trim().length() == 0) {
            throw new MalformedURIException("Argument schemeSpecificPart is null or an empty string");
        }
        this.setScheme(scheme);
        this.setPath(schemeSpecificPart);
    }

    public URI(String scheme, String host, String path, String queryString, String fragment) throws MalformedURIException {
        this(scheme, null, host, -1, path, queryString, fragment);
    }

    public URI(String scheme, String userinfo, String host, int port, String path, String queryString, String fragment) throws MalformedURIException {
        if (scheme == null || scheme.trim().length() == 0) {
            throw new MalformedURIException("Argument scheme is null or an empty string");
        }
        if (host == null) {
            if (userinfo != null) {
                throw new MalformedURIException("Argument userInfo must be null if host is null");
            }
            if (port != -1) {
                throw new MalformedURIException("Argument port must be null if host is null");
            }
        } else if (host.trim().length() == 0) {
            throw new IllegalArgumentException("Argument host is an empty string");
        }
        if (path != null) {
            if (path.indexOf(63) != -1 && queryString != null) {
                throw new MalformedURIException("Argument queryString is illegal if path includes query string");
            }
            if (path.indexOf(35) != -1 && fragment != null) {
                throw new MalformedURIException("Argument fragment is illegal if path includes fragment identifier");
            }
        } else if (path.trim().length() == 0) {
            throw new IllegalArgumentException("Argument path is an empty string");
        }
        this.setScheme(scheme);
        this.setHost(host);
        this.setPort(port);
        this.setUserinfo(userinfo);
        this.setPath(path);
        this.setQueryString(queryString);
        this.setFragment(fragment);
    }

    private void initialize(URI other) {
        this._scheme = other.getScheme();
        this._userinfo = other.getUserinfo();
        this._host = other.getHost();
        this._port = other.getPort();
        this._path = other.getPath();
        this._queryString = other.getQueryString();
        this._fragment = other.getFragment();
    }

    private void initialize(URI base, String uriSpec) throws MalformedURIException {
        if (base == null && (uriSpec == null || uriSpec.trim().length() == 0)) {
            throw new MalformedURIException("Argument base is null and argument uriSpec is null or an empty string");
        }
        if (uriSpec == null || uriSpec.trim().length() == 0) {
            this.initialize(base);
            return;
        }
        uriSpec = uriSpec.trim();
        int uriSpecLen = uriSpec.length();
        int index = 0;
        if (uriSpec.indexOf(58) == -1) {
            if (base == null) {
                throw new MalformedURIException("No scheme found in URI.");
            }
        } else {
            this.initializeScheme(uriSpec);
            index = this._scheme.length() + 1;
        }
        if (index + 1 < uriSpecLen && uriSpec.substring(index).startsWith("//")) {
            int startPos = index += 2;
            char testChar = '\u0000';
            while (index < uriSpecLen) {
                testChar = uriSpec.charAt(index);
                if (testChar == '/' || testChar == '?' || testChar == '#') break;
                ++index;
            }
            if (index > startPos) {
                this.initializeAuthority(uriSpec.substring(startPos, index));
            } else {
                this._host = "";
            }
        }
        this.initializePath(uriSpec.substring(index));
        if (base != null) {
            int lastSlash;
            if (this._path.length() == 0 && this._scheme == null && this._host == null) {
                this._scheme = base.getScheme();
                this._userinfo = base.getUserinfo();
                this._host = base.getHost();
                this._port = base.getPort();
                this._path = base.getPath();
                if (this._queryString == null) {
                    this._queryString = base.getQueryString();
                }
                return;
            }
            if (this._scheme != null) {
                return;
            }
            this._scheme = base.getScheme();
            if (this._host != null) {
                return;
            }
            this._userinfo = base.getUserinfo();
            this._host = base.getHost();
            this._port = base.getPort();
            if (this._path.length() > 0 && this._path.startsWith("/")) {
                return;
            }
            String tmpPath = new String();
            String basePath = base.getPath();
            if (basePath != null && (lastSlash = basePath.lastIndexOf(47)) != -1) {
                tmpPath = basePath.substring(0, lastSlash + 1);
            }
            tmpPath = tmpPath.concat(tmpPath);
            index = -1;
            while ((index = tmpPath.indexOf("/./")) != -1) {
                tmpPath = tmpPath.substring(0, index + 1).concat(tmpPath.substring(index + 3));
            }
            if (tmpPath.endsWith("/.")) {
                tmpPath = tmpPath.substring(0, tmpPath.length() - 1);
            }
            index = -1;
            int segIndex = -1;
            String tempString = null;
            while ((index = tmpPath.indexOf("/../")) > 0) {
                tempString = tmpPath.substring(0, tmpPath.indexOf("/../"));
                segIndex = tempString.lastIndexOf(47);
                if (segIndex == -1 || tempString.substring(segIndex++).equals("..")) continue;
                tmpPath = tmpPath.substring(0, segIndex).concat(tmpPath.substring(index + 4));
            }
            if (tmpPath.endsWith("/..") && (segIndex = (tempString = tmpPath.substring(0, tmpPath.length() - 3)).lastIndexOf(47)) != -1) {
                tmpPath = tmpPath.substring(0, segIndex + 1);
            }
            this._path = tmpPath;
        }
    }

    private void initializeScheme(String uriSpec) throws MalformedURIException {
        int uriSpecLen = uriSpec.length();
        int index = 0;
        String scheme = null;
        char testChar = '\u0000';
        while (index < uriSpecLen) {
            testChar = uriSpec.charAt(index);
            if (testChar == ':' || testChar == '/' || testChar == '?' || testChar == '#') break;
            ++index;
        }
        if ((scheme = uriSpec.substring(0, index)).length() == 0) {
            throw new MalformedURIException("No scheme found in URI.");
        }
        this.setScheme(scheme);
    }

    private void initializeAuthority(String uriSpec) throws MalformedURIException {
        int index = 0;
        int start = 0;
        int end = uriSpec.length();
        char testChar = '\u0000';
        String userinfo = null;
        if (uriSpec.indexOf(64, start) != -1) {
            while (index < end) {
                testChar = uriSpec.charAt(index);
                if (testChar == '@') break;
                ++index;
            }
            userinfo = uriSpec.substring(start, index);
            ++index;
        }
        String host = null;
        start = index;
        while (index < end) {
            testChar = uriSpec.charAt(index);
            if (testChar == ':') break;
            ++index;
        }
        host = uriSpec.substring(start, index);
        int port = -1;
        if (host.length() > 0 && testChar == ':') {
            start = ++index;
            while (index < end) {
                ++index;
            }
            String portStr = uriSpec.substring(start, index);
            if (portStr.length() > 0) {
                int i = 0;
                while (i < portStr.length()) {
                    if (!URI.isDigit(portStr.charAt(i))) {
                        throw new MalformedURIException(portStr + " is invalid. Port should only contain digits!");
                    }
                    ++i;
                }
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        this.setHost(host);
        this.setPort(port);
        this.setUserinfo(userinfo);
    }

    private void initializePath(String uriSpec) throws MalformedURIException {
        if (uriSpec == null) {
            throw new MalformedURIException("Argument uriSpec is null");
        }
        int index = 0;
        int start = 0;
        int end = uriSpec.length();
        char testChar = '\u0000';
        while (index < end) {
            testChar = uriSpec.charAt(index);
            if (testChar == '?' || testChar == '#') break;
            if (testChar == '%') {
                if (index + 2 >= end || !URI.isHex(uriSpec.charAt(index + 1)) || !URI.isHex(uriSpec.charAt(index + 2))) {
                    throw new MalformedURIException("Path contains invalid escape sequence!");
                }
            } else if (!URI.isReservedCharacter(testChar) && !URI.isUnreservedCharacter(testChar) && '\\' != testChar) {
                throw new MalformedURIException("Path contains invalid character: " + testChar);
            }
            ++index;
        }
        this._path = uriSpec.substring(start, index);
        if (testChar == '?') {
            start = ++index;
            while (index < end) {
                testChar = uriSpec.charAt(index);
                if (testChar == '#') break;
                if (testChar == '%') {
                    if (index + 2 >= end || !URI.isHex(uriSpec.charAt(index + 1)) || !URI.isHex(uriSpec.charAt(index + 2))) {
                        throw new MalformedURIException("Query string contains invalid escape sequence!");
                    }
                } else if (!URI.isReservedCharacter(testChar) && !URI.isUnreservedCharacter(testChar)) {
                    throw new MalformedURIException("Query string contains invalid character:" + testChar);
                }
                ++index;
            }
            this._queryString = uriSpec.substring(start, index);
        }
        if (testChar == '#') {
            start = ++index;
            while (index < end) {
                testChar = uriSpec.charAt(index);
                if (testChar == '%') {
                    if (index + 2 >= end || !URI.isHex(uriSpec.charAt(index + 1)) || !URI.isHex(uriSpec.charAt(index + 2))) {
                        throw new MalformedURIException("Fragment contains invalid escape sequence!");
                    }
                } else if (!URI.isReservedCharacter(testChar) && !URI.isUnreservedCharacter(testChar)) {
                    throw new MalformedURIException("Fragment contains invalid character:" + testChar);
                }
                ++index;
            }
            this._fragment = uriSpec.substring(start, index);
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer schemespec = new StringBuffer();
        if (this._userinfo != null || this._host != null || this._port != -1) {
            schemespec.append("//");
            if (this._userinfo != null) {
                schemespec.append(this._userinfo);
                schemespec.append('@');
            }
            if (this._host != null) {
                schemespec.append(this._host);
            }
            if (this._port != -1) {
                schemespec.append(':');
                schemespec.append(this._port);
            }
        }
        if (this._path != null) {
            schemespec.append(this._path);
        }
        if (this._queryString != null) {
            schemespec.append('?');
            schemespec.append(this._queryString);
        }
        if (this._fragment != null) {
            schemespec.append('#');
            schemespec.append(this._fragment);
        }
        return schemespec.toString();
    }

    public String getUserinfo() {
        return this._userinfo;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath(boolean includeQueryString, boolean includeFragment) {
        StringBuffer pathString = new StringBuffer(this._path);
        if (includeQueryString && this._queryString != null) {
            pathString.append('?');
            pathString.append(this._queryString);
        }
        if (includeFragment && this._fragment != null) {
            pathString.append('#');
            pathString.append(this._fragment);
        }
        return pathString.toString();
    }

    public String getPath() {
        return this._path;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public String getFragment() {
        return this._fragment;
    }

    public void setScheme(String scheme) throws MalformedURIException {
        if (scheme == null) {
            throw new MalformedURIException("Argument scheme is null");
        }
        if (!URI.isConformantSchemeName(scheme)) {
            throw new MalformedURIException("The scheme is not conformant.");
        }
        this._scheme = scheme.toLowerCase();
    }

    public void setUserinfo(String userinfo) throws MalformedURIException {
        if (userinfo == null) {
            this._userinfo = null;
        } else {
            if (this._host == null) {
                throw new MalformedURIException("Userinfo cannot be set when host is null!");
            }
            int index = 0;
            int end = userinfo.length();
            char testChar = '\u0000';
            while (index < end) {
                testChar = userinfo.charAt(index);
                if (testChar == '%') {
                    if (index + 2 >= end || !URI.isHex(userinfo.charAt(index + 1)) || !URI.isHex(userinfo.charAt(index + 2))) {
                        throw new MalformedURIException("Userinfo contains invalid escape sequence!");
                    }
                } else if (!URI.isUnreservedCharacter(testChar) && USERINFO_CHARACTERS.indexOf(testChar) == -1) {
                    throw new MalformedURIException("Userinfo contains invalid character:" + testChar);
                }
                ++index;
            }
        }
        this._userinfo = userinfo;
    }

    public void setHost(String host) throws MalformedURIException {
        if (host == null || host.trim().length() == 0) {
            this._host = host;
            this._userinfo = null;
            this._port = -1;
        } else if (!URI.isWellFormedAddress(host)) {
            throw new MalformedURIException("Host is not a well formed address!");
        }
        this._host = host;
    }

    public void setPort(int port) throws MalformedURIException {
        if (port >= 0 && port <= 65535) {
            if (this._host == null) {
                throw new MalformedURIException("Port cannot be set when host is null!");
            }
        } else if (port != -1) {
            throw new MalformedURIException("Invalid port number!");
        }
        this._port = port;
    }

    public void setPath(String path) throws MalformedURIException {
        if (path == null) {
            this._path = null;
            this._queryString = null;
            this._fragment = null;
        } else {
            this.initializePath(path);
        }
    }

    public void appendPath(String addToPath) throws MalformedURIException {
        if (addToPath == null || addToPath.trim().length() == 0) {
            return;
        }
        if (!URI.isURIString(addToPath)) {
            throw new MalformedURIException("Path contains invalid character!");
        }
        this._path = this._path == null || this._path.trim().length() == 0 ? (addToPath.startsWith("/") ? addToPath : "/" + addToPath) : (this._path.endsWith("/") ? (addToPath.startsWith("/") ? this._path.concat(addToPath.substring(1)) : this._path.concat(addToPath)) : (addToPath.startsWith("/") ? this._path.concat(addToPath) : this._path.concat("/" + addToPath)));
    }

    public void setQueryString(String queryString) throws MalformedURIException {
        if (queryString == null) {
            this._queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Query string can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Query string cannot be set when path is null!");
            }
            if (!URI.isURIString(queryString)) {
                throw new MalformedURIException("Query string contains invalid character!");
            }
            this._queryString = queryString;
        }
    }

    public void setFragment(String fragment) throws MalformedURIException {
        if (fragment == null) {
            this._fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Fragment can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Fragment cannot be set when path is null!");
            }
            if (!URI.isURIString(fragment)) {
                throw new MalformedURIException("Fragment contains invalid character!");
            }
            this._fragment = fragment;
        }
    }

    public boolean equals(Object test) {
        if (test instanceof URI) {
            URI testURI = (URI)test;
            return (this._scheme == null && testURI._scheme == null || this._scheme != null && testURI._scheme != null && this._scheme.equals(testURI._scheme)) && (this._userinfo == null && testURI._userinfo == null || this._userinfo != null && testURI._userinfo != null && this._userinfo.equals(testURI._userinfo)) && (this._host == null && testURI._host == null || this._host != null && testURI._host != null && this._host.equals(testURI._host)) && this._port == testURI._port && (this._path == null && testURI._path == null || this._path != null && testURI._path != null && this._path.equals(testURI._path)) && (this._queryString == null && testURI._queryString == null || this._queryString != null && testURI._queryString != null && this._queryString.equals(testURI._queryString)) && (this._fragment == null && testURI._fragment == null || this._fragment != null && testURI._fragment != null && this._fragment.equals(testURI._fragment));
        }
        return false;
    }

    public String toString() {
        StringBuffer uriSpecString = new StringBuffer();
        if (this._scheme != null) {
            uriSpecString.append(this._scheme);
            uriSpecString.append(':');
        }
        uriSpecString.append(this.getSchemeSpecificPart());
        return uriSpecString.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isGenericURI() {
        return this._host != null;
    }

    public static boolean isConformantSchemeName(String scheme) {
        if (scheme == null || scheme.trim().length() == 0) {
            return false;
        }
        if (!URI.isAlpha(scheme.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < scheme.length()) {
            char testChar = scheme.charAt(i);
            if (!URI.isAlphanum(testChar) && SCHEME_CHARACTERS.indexOf(testChar) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String address) {
        if (address == null) {
            return false;
        }
        int addrLength = (address = address.trim()).length();
        if (addrLength == 0 || addrLength > 255) {
            return false;
        }
        if (address.startsWith(".") || address.startsWith("-")) {
            return false;
        }
        int index = address.lastIndexOf(46);
        if (address.endsWith(".")) {
            index = address.substring(0, index).lastIndexOf(46);
        }
        if (index + 1 < addrLength && URI.isDigit(address.charAt(index + 1))) {
            int numDots = 0;
            int i = 0;
            while (i < addrLength) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!URI.isDigit(address.charAt(i - 1)) || i + 1 < addrLength && !URI.isDigit(address.charAt(i + 1))) {
                        return false;
                    }
                    ++numDots;
                } else if (!URI.isDigit(testChar)) {
                    return false;
                }
                ++i;
            }
            if (numDots != 3) {
                return false;
            }
        } else {
            int i = 0;
            while (i < addrLength) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!URI.isAlphanum(address.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 < addrLength && !URI.isAlphanum(address.charAt(i + 1))) {
                        return false;
                    }
                } else if (!URI.isAlphanum(testChar) && testChar != '-') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isHex(char ch) {
        return URI.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private static boolean isAlpha(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAlphanum(char ch) {
        return URI.isAlpha(ch) || URI.isDigit(ch);
    }

    private static boolean isReservedCharacter(char ch) {
        return RESERVED_CHARACTERS.indexOf(ch) != -1;
    }

    private static boolean isUnreservedCharacter(char ch) {
        return URI.isAlphanum(ch) || MARK_CHARACTERS.indexOf(ch) != -1;
    }

    private static boolean isURIString(String uric) {
        if (uric == null) {
            return false;
        }
        int end = uric.length();
        char testChar = '\u0000';
        int i = 0;
        while (i < end) {
            testChar = uric.charAt(i);
            if (testChar == '%') {
                if (i + 2 >= end || !URI.isHex(uric.charAt(i + 1)) || !URI.isHex(uric.charAt(i + 2))) {
                    return false;
                }
                i += 2;
            } else if (!URI.isReservedCharacter(testChar) && !URI.isUnreservedCharacter(testChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class MalformedURIException
    extends IOException {
        public MalformedURIException() {
        }

        public MalformedURIException(String message) {
            super(message);
        }
    }
}

