/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketManagedConnectionAcceptor;
import org.exolab.jms.net.tcp.TCPSManagedConnection;
import org.exolab.jms.net.tcp.TCPSRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.SSLHelper;
import org.exolab.jms.net.util.SSLProperties;

class TCPSManagedConnectionAcceptor
extends SocketManagedConnectionAcceptor {
    public TCPSManagedConnectionAcceptor(Authenticator authenticator, TCPSRequestInfo info) throws ResourceException {
        super(authenticator, info);
    }

    protected ServerSocket createServerSocket(int port, int backlog, InetAddress host) throws IOException {
        TCPSRequestInfo info = (TCPSRequestInfo)this.getRequestInfo();
        SSLProperties properties = info.getSSLProperties();
        if (properties != null) {
            SSLHelper.configure(properties);
        }
        ServerSocketFactory factory = SSLServerSocketFactory.getDefault();
        SSLServerSocket socket = (SSLServerSocket)factory.createServerSocket(port, backlog, host);
        socket.setNeedClientAuth(info.getNeedClientAuth());
        return socket;
    }

    protected ManagedConnection createManagedConnection(URI uri, Socket socket, Authenticator authenticator) throws ResourceException {
        return new TCPSManagedConnection(uri, socket, authenticator);
    }
}

