/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionAcceptorListener;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.URI;

public abstract class SocketManagedConnectionAcceptor
implements ManagedConnectionAcceptor {
    private Authenticator _authenticator;
    private ServerSocket _socket;
    private final URI _uri;
    private final ThreadGroup _group;
    private Dispatcher _dispatcher;
    private final SocketRequestInfo _info;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$socket$SocketManagedConnectionAcceptor == null ? (class$org$exolab$jms$net$socket$SocketManagedConnectionAcceptor = SocketManagedConnectionAcceptor.class$("org.exolab.jms.net.socket.SocketManagedConnectionAcceptor")) : class$org$exolab$jms$net$socket$SocketManagedConnectionAcceptor));
    static /* synthetic */ Class class$org$exolab$jms$net$socket$SocketManagedConnectionAcceptor;

    public SocketManagedConnectionAcceptor(Authenticator authenticator, SocketRequestInfo info) throws ResourceException {
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        if (info == null) {
            throw new IllegalArgumentException("Argument 'info' is null");
        }
        this._authenticator = authenticator;
        this._uri = info.getURI();
        this._info = info;
        int port = info.getPort();
        try {
            InetAddress host = null;
            if (!info.getBindAll()) {
                host = info.getHostAddress();
            }
            int backlog = info.getConnectionRequestQueueSize();
            this._socket = this.createServerSocket(port, backlog, host);
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to create server socket for URI=" + info.getURI(), exception);
        }
        this._group = new ThreadGroup(this._uri.toString());
        StringBuffer name = new StringBuffer();
        name.append(this._uri.toString());
        name.append("[server]");
    }

    public synchronized void accept(ManagedConnectionAcceptorListener listener) throws ResourceException {
        if (this._dispatcher != null) {
            throw new ResourceException("Acceptor is already accepting connections on URI=" + this._uri);
        }
        this._dispatcher = new Dispatcher(listener);
        this._dispatcher.start();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Acceptor accepting requests at URI=" + this._uri));
        }
    }

    public SocketRequestInfo getRequestInfo() {
        return this._info;
    }

    public URI getURI() {
        return this._uri;
    }

    public synchronized void close() throws ResourceException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Acceptor shutting down at URI=" + this._uri));
        }
        if (this._dispatcher != null) {
            this._dispatcher.close();
            if (Thread.currentThread() != this._dispatcher) {
                try {
                    this._dispatcher.join();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            this._dispatcher = null;
            this._socket = null;
        } else if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException exception) {
                throw new ResourceException("Failed to close socket", exception);
            }
        }
    }

    protected ServerSocket createServerSocket(int port, int backlog, InetAddress host) throws IOException {
        return new ServerSocket(port, backlog, host);
    }

    protected abstract ManagedConnection createManagedConnection(URI var1, Socket var2, Authenticator var3) throws ResourceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Dispatcher
    extends Thread {
        private final ManagedConnectionAcceptorListener _listener;
        private volatile boolean _closed = false;

        public Dispatcher(ManagedConnectionAcceptorListener listener) {
            super(SocketManagedConnectionAcceptor.this._group, SocketManagedConnectionAcceptor.this.getURI() + "[acceptor]");
            this._listener = listener;
        }

        public void close() {
            this._closed = true;
            try {
                SocketManagedConnectionAcceptor.this._socket.close();
            }
            catch (IOException exception) {
                _log.debug((Object)exception);
            }
        }

        public void run() {
            while (!this._closed) {
                try {
                    Socket socket = SocketManagedConnectionAcceptor.this._socket.accept();
                    socket.setTcpNoDelay(true);
                    ManagedConnection connection = SocketManagedConnectionAcceptor.this.createManagedConnection(SocketManagedConnectionAcceptor.this._uri, socket, SocketManagedConnectionAcceptor.this._authenticator);
                    this._listener.accepted(SocketManagedConnectionAcceptor.this, connection);
                }
                catch (Exception exception) {
                    if (this._closed) break;
                    this._listener.error(SocketManagedConnectionAcceptor.this, exception);
                    break;
                }
            }
        }
    }
}

