/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.rmi.RMIInvokerFactory;
import org.exolab.jms.net.uri.URI;

final class RegistryHelper {
    private static final String BIND_SUFFIX = (class$org$exolab$jms$net$rmi$RMIInvokerFactory == null ? (class$org$exolab$jms$net$rmi$RMIInvokerFactory = RegistryHelper.class$("org.exolab.jms.net.rmi.RMIInvokerFactory")) : class$org$exolab$jms$net$rmi$RMIInvokerFactory).getName();
    static /* synthetic */ Class class$org$exolab$jms$net$rmi$RMIInvokerFactory;

    private RegistryHelper() {
    }

    public static void bind(RMIInvokerFactory factory, URI uri, Registry registry) throws ResourceException {
        String name = RegistryHelper.getName(uri);
        try {
            registry.bind(name, factory);
        }
        catch (AlreadyBoundException exception) {
            throw new ResourceException("Binding exists for " + name, exception);
        }
        catch (RemoteException exception) {
            throw new ResourceException("Failed to bind connection factory", exception);
        }
    }

    public static void unbind(RMIInvokerFactory factory, URI uri, Registry registry) throws ResourceException {
        String name = RegistryHelper.getName(uri);
        try {
            registry.unbind(name);
        }
        catch (NotBoundException exception) {
            throw new ResourceException("No binding exists for " + name, exception);
        }
        catch (RemoteException exception) {
            throw new ResourceException("Failed to unbind connection factory", exception);
        }
    }

    public static String getName(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            path = "/";
        } else if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path + BIND_SUFFIX;
    }

    public static boolean hasBindings(Registry registry) throws RemoteException {
        String[] names = registry.list();
        return names.length != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

