/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionAcceptorListener;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.rmi.RMIInvokerFactory;
import org.exolab.jms.net.rmi.RMIInvokerFactoryImpl;
import org.exolab.jms.net.rmi.RMIRequestInfo;
import org.exolab.jms.net.rmi.RegistryHelper;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

class RMIManagedConnectionAcceptor
implements ManagedConnectionAcceptor {
    private final Authenticator _authenticator;
    private final URI _uri;
    private final boolean _embedRegistry;
    private Registry _registry;
    private boolean _created = false;
    private RMIInvokerFactory _factory;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$rmi$RMIManagedConnectionAcceptor == null ? (class$org$exolab$jms$net$rmi$RMIManagedConnectionAcceptor = RMIManagedConnectionAcceptor.class$("org.exolab.jms.net.rmi.RMIManagedConnectionAcceptor")) : class$org$exolab$jms$net$rmi$RMIManagedConnectionAcceptor));
    static /* synthetic */ Class class$org$exolab$jms$net$rmi$RMIManagedConnectionAcceptor;

    public RMIManagedConnectionAcceptor(Authenticator authenticator, RMIRequestInfo info) {
        this._authenticator = authenticator;
        this._uri = URIHelper.convertHostToAddress(info.getURI());
        this._embedRegistry = info.getEmbedRegistry();
    }

    public void accept(ManagedConnectionAcceptorListener listener) throws ResourceException {
        int port;
        Registry registry;
        block8: {
            registry = null;
            port = this._uri.getPort();
            if (this._embedRegistry) {
                try {
                    registry = LocateRegistry.createRegistry(port);
                    this._created = true;
                }
                catch (RemoteException exception) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)("Failed to create registry on port=" + port + ", attempting to locate one"), (Throwable)exception);
                }
            }
        }
        if (registry == null) {
            try {
                registry = LocateRegistry.getRegistry(port);
                port = 0;
            }
            catch (RemoteException nested) {
                throw new ResourceException("Failed to create or locate a registry, port=" + port, nested);
            }
        }
        this._factory = new RMIInvokerFactoryImpl(this._authenticator, this, listener);
        try {
            UnicastRemoteObject.exportObject((Remote)this._factory, port);
        }
        catch (RemoteException exception) {
            throw new ResourceException("Failed to export object", exception);
        }
        RegistryHelper.bind(this._factory, this._uri, registry);
        this._registry = registry;
    }

    public URI getURI() {
        return this._uri;
    }

    public synchronized void close() throws ResourceException {
        if (this._registry != null) {
            try {
                block6: {
                    try {
                        RegistryHelper.unbind(this._factory, this._uri, this._registry);
                        if (!UnicastRemoteObject.unexportObject(this._factory, true)) {
                            _log.warn((Object)"Failed to unexport invoker factory");
                        }
                        if (!this._created || RegistryHelper.hasBindings(this._registry) || UnicastRemoteObject.unexportObject(this._registry, true)) break block6;
                        _log.warn((Object)"Failed to unexport registry");
                    }
                    catch (RemoteException exception) {
                        throw new ResourceException("Failed to close connection acceptor", exception);
                    }
                }
                Object var3_1 = null;
                this._factory = null;
                this._registry = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this._factory = null;
                this._registry = null;
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

