/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.rmi;

import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.uuid.UUIDGenerator;
import org.exolab.jms.net.connector.AbstractManagedConnection;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerImpl;
import org.exolab.jms.net.connector.ConnectException;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.IllegalStateException;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnectionListener;
import org.exolab.jms.net.connector.MarshalledInvocation;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.connector.SecurityException;
import org.exolab.jms.net.rmi.RMIConnection;
import org.exolab.jms.net.rmi.RMIInvoker;
import org.exolab.jms.net.rmi.RMIInvokerFactory;
import org.exolab.jms.net.rmi.RMIInvokerImpl;
import org.exolab.jms.net.rmi.RMIRequestInfo;
import org.exolab.jms.net.rmi.RegistryHelper;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

class RMIManagedConnection
extends AbstractManagedConnection {
    private RMIInvokerImpl _localInvoker;
    private RMIInvoker _remoteInvoker;
    private InvocationHandler _invoker;
    private URI _remoteURI;
    private URI _localURI;
    private Principal _principal;
    private Caller _caller;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$rmi$RMIManagedConnection == null ? (class$org$exolab$jms$net$rmi$RMIManagedConnection = RMIManagedConnection.class$("org.exolab.jms.net.rmi.RMIManagedConnection")) : class$org$exolab$jms$net$rmi$RMIManagedConnection));
    static /* synthetic */ Class class$org$exolab$jms$net$rmi$RMIManagedConnection;

    protected RMIManagedConnection(Principal principal, RMIRequestInfo info) throws ResourceException {
        RMIInvokerFactory factory;
        Registry registry;
        this._remoteURI = URIHelper.convertHostToAddress(info.getURI());
        this._localURI = this.generateLocalURI();
        try {
            registry = LocateRegistry.getRegistry(info.getHost(), info.getPort());
        }
        catch (RemoteException exception) {
            throw new ConnectException("Failed to get registry, host=" + info.getHost() + ", port=" + info.getPort(), exception);
        }
        String name = RegistryHelper.getName(this._remoteURI);
        try {
            factory = (RMIInvokerFactory)registry.lookup(name);
        }
        catch (RemoteException exception) {
            throw new ConnectException("Failed to lookup connection proxy, host=" + info.getHost() + ", port=" + info.getPort(), exception);
        }
        catch (NotBoundException exception) {
            throw new ConnectException("Connection proxy=" + name + " not bound in " + "registry, host=" + info.getHost() + ", port=" + info.getPort(), exception);
        }
        this._localInvoker = new RMIInvokerImpl();
        this._localInvoker.setConnection(this);
        try {
            UnicastRemoteObject.exportObject(this._localInvoker);
        }
        catch (RemoteException exception) {
            throw new ResourceException("Failed to export invocation handler", exception);
        }
        try {
            this._remoteInvoker = factory.createInvoker(principal, this._localInvoker, this._localURI.toString());
        }
        catch (AccessException exception) {
            throw new SecurityException(exception.getMessage(), exception);
        }
        catch (RemoteException exception) {
            if (exception.detail instanceof AccessException) {
                throw new SecurityException(exception.getMessage(), exception.detail);
            }
            throw new ResourceException("Failed to create invocation handler", exception);
        }
        this._principal = principal;
    }

    protected RMIManagedConnection(Principal principal, RMIInvokerImpl localInvoker, URI localURI, RMIInvoker remoteInvoker, URI remoteURI) throws RemoteException {
        localInvoker.setConnection(this);
        UnicastRemoteObject.exportObject((Remote)localInvoker, localURI.getPort());
        this._localInvoker = localInvoker;
        this._localURI = localURI;
        this._remoteInvoker = remoteInvoker;
        this._remoteURI = remoteURI;
        this._principal = principal;
        this._caller = new CallerImpl(this._remoteURI, this._localURI);
    }

    public synchronized Connection getConnection() throws IllegalStateException {
        if (this._invoker == null) {
            throw new IllegalStateException("No InvocationHandler registered");
        }
        return new RMIConnection(this);
    }

    public synchronized void setInvocationHandler(InvocationHandler handler) throws IllegalStateException {
        if (this._invoker != null) {
            throw new IllegalStateException("An invocation handler is already registered");
        }
        this._invoker = handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ping() throws ResourceException {
        RMIInvoker invoker;
        RMIManagedConnection rMIManagedConnection = this;
        synchronized (rMIManagedConnection) {
            invoker = this._remoteInvoker;
        }
        if (invoker == null) throw new IllegalStateException("Connection not established");
        try {
            invoker.ping();
            ManagedConnectionListener listener = this.getConnectionEventListener();
            if (listener == null) return;
            listener.pinged(this);
            return;
        }
        catch (RemoteException exception) {
            throw new ResourceException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void destroy() throws ResourceException {
        RMIManagedConnection rMIManagedConnection2 = this;
        // MONITORENTER : rMIManagedConnection2
        RMIInvokerImpl localInvoker = this._localInvoker;
        RMIInvoker remoteInvoker = this._remoteInvoker;
        // MONITOREXIT : rMIManagedConnection2
        if (remoteInvoker != null) {
            try {
                remoteInvoker.disconnect();
            }
            catch (RemoteException ignore) {
                // empty catch block
            }
        }
        try {
            block12: {
                try {
                    if (localInvoker == null || UnicastRemoteObject.unexportObject(localInvoker, true)) break block12;
                    _log.warn((Object)"Failed to unexport invocation handler");
                }
                catch (RemoteException exception) {
                    throw new ResourceException("Failed to unexport invocation handler", exception);
                }
            }
            Object var6_6 = null;
            RMIManagedConnection rMIManagedConnection = this;
            // MONITORENTER : rMIManagedConnection
            this._localInvoker = null;
            this._remoteInvoker = null;
            // MONITOREXIT : rMIManagedConnection
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            RMIManagedConnection rMIManagedConnection = this;
            // MONITORENTER : rMIManagedConnection
            this._localInvoker = null;
            this._remoteInvoker = null;
            // MONITOREXIT : rMIManagedConnection
            throw throwable;
        }
    }

    public URI getRemoteURI() {
        return this._remoteURI;
    }

    public URI getLocalURI() {
        return this._localURI;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean hasPrincipal(Principal principal) {
        boolean result = false;
        if (this._principal != null && this._principal.equals(principal) || this._principal == null && principal == null) {
            result = true;
        }
        return result;
    }

    protected Response invoke(Connection connection, Request request) throws RemoteException {
        Response response;
        try {
            MarshalledObject<Request> wrappedRequest = new MarshalledObject<Request>(request);
            MarshalledObject wrappedResponse = this._remoteInvoker.invoke(wrappedRequest);
            response = (Response)wrappedResponse.get();
        }
        catch (ClassNotFoundException exception) {
            response = new Response(exception);
        }
        catch (IOException exception) {
            response = new Response(exception);
        }
        return response;
    }

    protected MarshalledObject invokeLocal(MarshalledObject request) throws MarshalException {
        MarshalledObject response;
        MarshalledInvocation invocation = new MarshalledInvocation(request, this._caller);
        this._invoker.invoke(invocation);
        try {
            response = invocation.getMarshalledResponse();
        }
        catch (Exception exception) {
            throw new MarshalException("Failed to marshal response", exception);
        }
        return response;
    }

    protected void disconnect() {
        RMIManagedConnection rMIManagedConnection = this;
        synchronized (rMIManagedConnection) {
            this._remoteInvoker = null;
        }
        this.notifyClosed();
    }

    private URI generateLocalURI() throws ResourceException {
        URI result;
        String path = UUIDGenerator.create();
        try {
            result = URIHelper.create("rmi", null, -1, path);
        }
        catch (InvalidURIException exception) {
            throw new ResourceException("Failed to generate local URI", exception);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

