/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.rmi;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.security.Principal;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ManagedConnectionAcceptorListener;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.rmi.RMIInvoker;
import org.exolab.jms.net.rmi.RMIInvokerFactory;
import org.exolab.jms.net.rmi.RMIInvokerImpl;
import org.exolab.jms.net.rmi.RMIManagedConnection;
import org.exolab.jms.net.rmi.RMIManagedConnectionAcceptor;
import org.exolab.jms.net.uri.URIHelper;

public class RMIInvokerFactoryImpl
extends RemoteObject
implements RMIInvokerFactory {
    private final Authenticator _authenticator;
    private final RMIManagedConnectionAcceptor _acceptor;
    private final ManagedConnectionAcceptorListener _listener;

    public RMIInvokerFactoryImpl(Authenticator authenticator, RMIManagedConnectionAcceptor acceptor, ManagedConnectionAcceptorListener listener) {
        this._authenticator = authenticator;
        this._acceptor = acceptor;
        this._listener = listener;
    }

    public RMIInvoker createInvoker(Principal principal, RMIInvoker client, String uri) throws RemoteException {
        try {
            if (!this._authenticator.authenticate(principal)) {
                throw new AccessException("Failed to authenticate");
            }
        }
        catch (ResourceException exception) {
            throw new AccessException("Failed to authenticate", exception);
        }
        RMIInvokerImpl invoker = new RMIInvokerImpl();
        RMIManagedConnection connection = new RMIManagedConnection(principal, invoker, this._acceptor.getURI(), client, URIHelper.parse(uri));
        this._listener.accepted(this._acceptor, connection);
        return invoker;
    }
}

