/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.orb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.server.ObjID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.ConnectionContext;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.proxy.Delegate;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URIHelper;

public class UnicastDelegate
implements Delegate,
Serializable {
    static final long serialVersionUID = 1L;
    private ObjID _objID;
    private String _uri;
    private transient Connection _connection;
    private transient ConnectionFactory _factory;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$orb$UnicastDelegate == null ? (class$org$exolab$jms$net$orb$UnicastDelegate = UnicastDelegate.class$("org.exolab.jms.net.orb.UnicastDelegate")) : class$org$exolab$jms$net$orb$UnicastDelegate));
    static /* synthetic */ Class class$org$exolab$jms$net$orb$UnicastDelegate;

    protected UnicastDelegate() {
    }

    public UnicastDelegate(ObjID objID, String uri) {
        this._objID = objID;
        this._uri = uri;
    }

    public UnicastDelegate(ObjID objID, Connection connection) {
        this._objID = objID;
        this._connection = connection;
    }

    public Object invoke(Method method, Object[] args, long methodID) throws Throwable {
        Request request = new Request(this._objID, method, args, methodID);
        Response response = this.getConnection().invoke(request);
        if (response.isException()) {
            throw response.getException();
        }
        return response.getObject();
    }

    public synchronized void dispose() {
        if (this._connection != null) {
            try {
                try {
                    this._connection.close();
                }
                catch (ResourceException exception) {
                    _log.warn((Object)"Failed to close connection", (Throwable)exception);
                    Object var3_2 = null;
                    this._connection = null;
                    this._factory = null;
                }
                Object var3_1 = null;
                this._connection = null;
                this._factory = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._connection = null;
                this._factory = null;
                throw throwable;
            }
        }
    }

    protected synchronized Connection getConnection() throws InvalidURIException, ResourceException {
        if (this._connection == null) {
            this._connection = this._factory.getConnection(null, URIHelper.parse(this._uri));
        }
        return this._connection;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this._connection = ConnectionContext.getConnection(URIHelper.parse(this._uri));
        if (this._connection == null) {
            this._factory = ConnectionContext.getConnectionFactory();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

