/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.orb;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.ExportException;
import java.security.Principal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.security.BasicPrincipal;
import org.exolab.jms.common.threads.DefaultThreadPoolFactory;
import org.exolab.jms.common.threads.ThreadPoolFactory;
import org.exolab.jms.net.connector.AbstractConnectionManager;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.Invocation;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.MulticastCallerListener;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.orb.AbstractORB;
import org.exolab.jms.net.orb.DefaultConnectionManager;
import org.exolab.jms.net.orb.Locator;
import org.exolab.jms.net.orb.RegistryService;
import org.exolab.jms.net.proxy.Proxy;
import org.exolab.jms.net.registry.LocalRegistry;
import org.exolab.jms.net.registry.Registry;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.MethodHelper;
import org.exolab.jms.net.util.Properties;

class DefaultORB
extends AbstractORB {
    private LocalRegistry _registry;
    private AbstractConnectionManager _manager;
    private MulticastCallerListener _listeners;
    private ThreadPoolFactory _factory;
    private PooledExecutor _pool;
    private int _maxThreads;
    private final Object _poolLock = new Object();
    private final ThreadLocal _caller = new ThreadLocal();
    private static final String MAX_THREADS_NAME = "org.exolab.jms.net.orb.threads.max";
    private static final String THREAD_POOL_FACTORY = "org.exolab.jms.net.orb.threads.factory";
    private static final int MAX_THREADS = Integer.MAX_VALUE;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$orb$DefaultORB == null ? (class$org$exolab$jms$net$orb$DefaultORB = DefaultORB.class$("org.exolab.jms.net.orb.DefaultORB")) : class$org$exolab$jms$net$orb$DefaultORB));
    static /* synthetic */ Class class$org$exolab$jms$net$orb$DefaultORB;

    public DefaultORB(Authenticator authenticator) throws RemoteException {
        this(authenticator, (class$org$exolab$jms$net$orb$DefaultORB == null ? (class$org$exolab$jms$net$orb$DefaultORB = DefaultORB.class$("org.exolab.jms.net.orb.DefaultORB")) : class$org$exolab$jms$net$orb$DefaultORB).getClassLoader(), null);
    }

    public DefaultORB(Authenticator authenticator, Map properties) throws RemoteException {
        this(authenticator, (class$org$exolab$jms$net$orb$DefaultORB == null ? (class$org$exolab$jms$net$orb$DefaultORB = DefaultORB.class$("org.exolab.jms.net.orb.DefaultORB")) : class$org$exolab$jms$net$orb$DefaultORB).getClassLoader(), properties);
    }

    public DefaultORB(Map properties) throws RemoteException {
        this(new DummyAuthenticator(), (class$org$exolab$jms$net$orb$DefaultORB == null ? (class$org$exolab$jms$net$orb$DefaultORB = DefaultORB.class$("org.exolab.jms.net.orb.DefaultORB")) : class$org$exolab$jms$net$orb$DefaultORB).getClassLoader(), properties);
    }

    public DefaultORB() throws RemoteException {
        this(new DummyAuthenticator(), (class$org$exolab$jms$net$orb$DefaultORB == null ? (class$org$exolab$jms$net$orb$DefaultORB = DefaultORB.class$("org.exolab.jms.net.orb.DefaultORB")) : class$org$exolab$jms$net$orb$DefaultORB).getClassLoader(), null);
    }

    public DefaultORB(Authenticator authenticator, ClassLoader loader, Map properties) throws RemoteException {
        super(loader, properties);
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        Properties helper = new Properties(properties, null);
        try {
            this._maxThreads = helper.getInt(MAX_THREADS_NAME, Integer.MAX_VALUE);
        }
        catch (ResourceException exception) {
            throw new RemoteException("Failed to construct thread pool", exception);
        }
        this._factory = (ThreadPoolFactory)helper.getProperties().get(THREAD_POOL_FACTORY);
        if (this._factory == null) {
            this._factory = new DefaultThreadPoolFactory(null);
        }
        try {
            this._manager = this.createConnectionManager(new Handler(), authenticator);
        }
        catch (ResourceException exception) {
            throw new RemoteException("Failed to construct connection manager", exception);
        }
    }

    public synchronized LocalRegistry getRegistry() throws RemoteException {
        if (this._registry == null) {
            this._registry = new RegistryService(this);
        }
        return this._registry;
    }

    public Registry getRegistry(Map properties) throws RemoteException {
        Registry registry;
        if (properties == null || properties.get("org.exolab.jms.net.orb.provider.uri") == null) {
            throw new ConnectException("org.exolab.jms.net.orb.provider.uri not specified");
        }
        String uri = (String)properties.get("org.exolab.jms.net.orb.provider.uri");
        String principal = (String)properties.get("org.exolab.jms.net.orb.security.principal");
        String credentials = (String)properties.get("org.exolab.jms.net.orb.security.credentials");
        BasicPrincipal subject = null;
        if (principal != null) {
            subject = new BasicPrincipal(principal, credentials);
        }
        try {
            registry = Locator.getRegistry((Principal)subject, uri, this._manager, this.getProxyClassLoader(), properties);
        }
        catch (InvalidURIException exception) {
            throw new RemoteException("Invalid URI: " + uri, exception);
        }
        return registry;
    }

    public Proxy exportObjectTo(Object object) throws ExportException, StubNotFoundException {
        Caller caller = (Caller)this._caller.get();
        if (caller == null) {
            throw new ExportException("Cannot export - no current caller");
        }
        return this.doExportTo(object, caller.getLocalURI());
    }

    public synchronized void unexportObject(Object object) throws NoSuchObjectException {
        super.unexportObject(object);
        if (this.getExported() == 0) {
            Object object2 = this._poolLock;
            synchronized (object2) {
                if (this._pool != null) {
                    _log.debug((Object)"Shutting down thread pool");
                    this._pool.shutdownNow();
                    this._pool = null;
                }
            }
        }
    }

    public Caller getCaller() throws RemoteException {
        return (Caller)this._caller.get();
    }

    public void addCallerListener(String uri, CallerListener listener) throws InvalidURIException {
        DefaultORB defaultORB = this;
        synchronized (defaultORB) {
            if (this._listeners == null) {
                this._listeners = new MulticastCallerListener();
                this._manager.setCallerListener(this._listeners);
            }
        }
        this._listeners.addCallerListener(uri, listener);
    }

    public void removeCallerListener(String uri, CallerListener listener) throws InvalidURIException {
        MulticastCallerListener listeners = null;
        DefaultORB defaultORB = this;
        synchronized (defaultORB) {
            listeners = this._listeners;
        }
        if (listeners != null) {
            listeners.removeCallerListener(uri, listener);
        }
    }

    public void shutdown() throws RemoteException {
        try {
            this._manager.close();
        }
        catch (ResourceException exception) {
            throw new RemoteException("Failed to close connection manager", exception);
        }
    }

    protected AbstractConnectionManager createConnectionManager(InvocationHandler handler, Authenticator authenticator) throws ResourceException {
        return new DefaultConnectionManager(handler, authenticator, this.getProperties());
    }

    protected URI connect(URI uri, String principal, String credentials) throws ExportException {
        URI result;
        try {
            BasicPrincipal subject = null;
            if (principal != null) {
                subject = new BasicPrincipal(principal, credentials);
            }
            Connection connection = this._manager.getConnection((Principal)subject, uri);
            result = connection.getLocalURI();
            connection.close();
        }
        catch (ResourceException exception) {
            throw new ExportException("Failed to connect to URI: " + uri, exception);
        }
        return result;
    }

    protected void accept(URI uri) throws ExportException {
        try {
            this._manager.accept(uri, this.getProperties());
        }
        catch (ResourceException exception) {
            throw new ExportException("Failed to accept connections on URI: " + uri, exception);
        }
    }

    private PooledExecutor getThreadPool() {
        Object object = this._poolLock;
        synchronized (object) {
            if (this._pool == null) {
                this._pool = this._factory.create("ORB", this._maxThreads);
                this._pool.abortWhenBlocked();
            }
            PooledExecutor pooledExecutor = this._pool;
            return pooledExecutor;
        }
    }

    private Method getMethod(Object object, long methodID) throws NoSuchMethodException {
        Method result = null;
        Method[] methods = MethodHelper.getAllInterfaceMethods(object.getClass());
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (MethodHelper.getMethodID(method) == methodID) {
                result = method;
                break;
            }
            ++i;
        }
        if (result == null) {
            throw new NoSuchMethodException("Failed to resolve method for methodID=" + methodID);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DummyAuthenticator
    implements Authenticator {
        private DummyAuthenticator() {
        }

        public boolean authenticate(Principal principal) throws ResourceException {
            return true;
        }
    }

    private class Handler
    implements InvocationHandler {
        private Handler() {
        }

        public void invoke(final Invocation invocation) {
            Runnable invoker = new Runnable(){

                public void run() {
                    Response response;
                    try {
                        Request request = invocation.getRequest();
                        Caller caller = invocation.getCaller();
                        response = this.invoke(request, caller);
                    }
                    catch (Throwable exception) {
                        response = new Response(exception);
                    }
                    invocation.setResponse(response);
                }
            };
            try {
                DefaultORB.this.getThreadPool().execute(invoker);
            }
            catch (Throwable exception) {
                _log.debug((Object)"Pool failed to execute invocation", exception);
                invocation.setResponse(new Response(exception));
            }
        }

        protected Response invoke(Request request, Caller caller) {
            Response response;
            block9: {
                try {
                    try {
                        Object[] args;
                        Object object = DefaultORB.this.getObject(request.getObjID(), request.getURI());
                        Method method = request.getMethod();
                        if (method == null) {
                            method = DefaultORB.this.getMethod(object, request.getMethodID());
                        }
                        if ((args = request.getArgs()) == null) {
                            args = request.readArgs(method);
                        }
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Invoking " + method + " on " + object));
                        }
                        DefaultORB.this._caller.set(caller);
                        Object result = method.invoke(object, args);
                        response = new Response(result, method);
                    }
                    catch (InvocationTargetException exception) {
                        Throwable target = exception.getTargetException();
                        if (target == null) {
                            target = exception;
                        }
                        response = new Response(target);
                        Object var9_12 = null;
                        DefaultORB.this._caller.set(null);
                        break block9;
                    }
                    catch (Throwable exception) {
                        response = new Response(exception);
                        Object var9_13 = null;
                        DefaultORB.this._caller.set(null);
                    }
                    Object var9_11 = null;
                    DefaultORB.this._caller.set(null);
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    DefaultORB.this._caller.set(null);
                    throw throwable;
                }
            }
            return response;
        }
    }
}

