/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.multiplexer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.security.BasicPrincipal;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.SecurityException;
import org.exolab.jms.net.multiplexer.Channel;
import org.exolab.jms.net.multiplexer.Constants;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.multiplexer.MultiplexInputStream;
import org.exolab.jms.net.multiplexer.MultiplexOutputStream;
import org.exolab.jms.net.multiplexer.MultiplexerListener;

public class Multiplexer
implements Constants,
Runnable {
    private MultiplexerListener _listener;
    private volatile boolean _closed;
    private Endpoint _endpoint;
    private DataOutputStream _out;
    private DataInputStream _in;
    private final HashMap _channels = new HashMap();
    private final LinkedList _free = new LinkedList();
    private boolean _client = false;
    private int _seed = 0;
    private Principal _principal;
    private static final int BUFFER_SIZE = 2048;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$multiplexer$Multiplexer == null ? (class$org$exolab$jms$net$multiplexer$Multiplexer = Multiplexer.class$("org.exolab.jms.net.multiplexer.Multiplexer")) : class$org$exolab$jms$net$multiplexer$Multiplexer));
    static /* synthetic */ Class class$org$exolab$jms$net$multiplexer$Multiplexer;

    public Multiplexer(MultiplexerListener listener, Endpoint endpoint, Principal principal) throws IOException, SecurityException {
        this.initialise(listener, endpoint, true);
        this.authenticate(principal);
    }

    public Multiplexer(MultiplexerListener listener, Endpoint endpoint, Authenticator authenticator) throws IOException, ResourceException {
        this.initialise(listener, endpoint, false);
        this.authenticate(authenticator);
    }

    protected Multiplexer() {
    }

    public void run() {
        while (!this._closed) {
            this.multiplex();
        }
    }

    public Channel getChannel() throws IOException {
        Channel channel = null;
        LinkedList linkedList = this._free;
        synchronized (linkedList) {
            if (!this._free.isEmpty()) {
                channel = (Channel)this._free.removeFirst();
            }
        }
        if (channel == null) {
            channel = this.open();
        }
        return channel;
    }

    public void release(Channel channel) {
        LinkedList linkedList = this._free;
        synchronized (linkedList) {
            this._free.add(channel);
        }
    }

    public void close(Channel channel) throws IOException {
        int channelId = channel.getId();
        HashMap hashMap = this._channels;
        synchronized (hashMap) {
            this._channels.remove(new Integer(channelId));
        }
        this.send((byte)33, channelId);
    }

    public void send(byte type) throws IOException {
        DataOutputStream dataOutputStream = this._out;
        synchronized (dataOutputStream) {
            this._out.writeByte(type);
            this._out.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("send(type=0x" + Integer.toHexString(type) + ")"));
            }
        }
    }

    public void send(byte type, int channelId) throws IOException {
        DataOutputStream dataOutputStream = this._out;
        synchronized (dataOutputStream) {
            this._out.writeByte(type);
            this._out.writeShort(channelId);
            this._out.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("send(type=0x" + Integer.toHexString(type) + ", channel=" + channelId + ")"));
            }
        }
    }

    public void send(byte type, int channelId, int data) throws IOException {
        DataOutputStream dataOutputStream = this._out;
        synchronized (dataOutputStream) {
            this._out.writeByte(type);
            this._out.writeShort(channelId);
            this._out.writeInt(data);
            this._out.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("send(type=" + type + ", channel=" + channelId + ", data=" + Integer.toHexString(data) + ")"));
            }
        }
    }

    public void send(byte type, int channelId, byte[] data, int offset, int length) throws IOException {
        DataOutputStream dataOutputStream = this._out;
        synchronized (dataOutputStream) {
            this._out.writeByte(type);
            this._out.writeShort(channelId);
            this._out.writeInt(length);
            this._out.write(data, offset, length);
            this._out.flush();
        }
    }

    public void ping(int token) throws IOException {
        DataOutputStream dataOutputStream = this._out;
        synchronized (dataOutputStream) {
            this._out.writeByte(80);
            this._out.writeInt(token);
            this._out.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("ping(token=" + token + ")"));
            }
        }
    }

    public void close() {
        if (!this._closed) {
            this._closed = true;
            try {
                this.send((byte)112);
            }
            catch (IOException exception) {
                _log.debug((Object)exception);
            }
            try {
                this._endpoint.close();
            }
            catch (IOException exception) {
                _log.debug((Object)exception);
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public boolean isClient() {
        return this._client;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    protected void initialise(MultiplexerListener listener, Endpoint endpoint, boolean client) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' is null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Argument 'endpoint' is null");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Multiplexer(uri=" + endpoint.getURI() + ", client=" + client));
        }
        this._listener = listener;
        this._endpoint = endpoint;
        this._out = new DataOutputStream(endpoint.getOutputStream());
        this._in = new DataInputStream(endpoint.getInputStream());
        this._client = client;
        this.handshake(this._out, this._in);
    }

    protected void handshake(DataOutputStream out, DataInputStream in) throws IOException {
        out.writeInt(-1159861073);
        out.writeInt(1);
        out.flush();
        int magic = in.readInt();
        if (magic != -1159861073) {
            throw new ProtocolException("Expected protocol magic=-1159861073, but received=" + magic);
        }
        int version = in.readInt();
        if (version != 1) {
            throw new ProtocolException("Expected protocol version=1, but received=" + version);
        }
    }

    protected void authenticate(Principal principal) throws IOException, SecurityException {
        try {
            if (principal != null && !(principal instanceof BasicPrincipal)) {
                throw new IOException("Cannot authenticate with principal of type " + principal.getClass().getName());
            }
            if (principal != null) {
                BasicPrincipal basic = (BasicPrincipal)principal;
                this._out.writeByte(64);
                this._out.writeUTF(basic.getName());
                this._out.writeUTF(basic.getPassword());
            } else {
                this._out.writeByte(65);
            }
            this._out.flush();
            if (this._in.readByte() != 78) {
                throw new SecurityException("Connection refused");
            }
        }
        catch (IOException exception) {
            this._endpoint.close();
            throw exception;
        }
        this._principal = principal;
    }

    protected void authenticate(Authenticator authenticator) throws IOException, ResourceException {
        try {
            BasicPrincipal principal = null;
            byte type = this._in.readByte();
            switch (type) {
                case 64: {
                    String name = this._in.readUTF();
                    String password = this._in.readUTF();
                    principal = new BasicPrincipal(name, password);
                    break;
                }
                case 65: {
                    break;
                }
                default: {
                    throw new IOException("Invalid packet type: " + type);
                }
            }
            if (!authenticator.authenticate((Principal)principal)) {
                this._out.writeByte(79);
                this._out.flush();
                throw new SecurityException("User " + principal + " unauthorised");
            }
            this._out.writeByte(78);
            this._out.flush();
            this._principal = principal;
        }
        catch (IOException exception) {
            this._endpoint.close();
            throw exception;
        }
        catch (ResourceException exception) {
            this._endpoint.close();
            throw exception;
        }
    }

    protected Channel open() throws IOException {
        Channel channel;
        int channelId;
        HashMap hashMap = this._channels;
        synchronized (hashMap) {
            channelId = this.getNextChannelId();
            channel = this.addChannel(channelId);
        }
        this.send((byte)32, channelId);
        return channel;
    }

    private void multiplex() {
        block13: {
            try {
                byte type = this._in.readByte();
                switch (type) {
                    case 32: {
                        this.handleOpen();
                        break;
                    }
                    case 33: {
                        this.handleClose();
                        break;
                    }
                    case 48: {
                        this.handleRequest();
                        break;
                    }
                    case 49: {
                        this.handleResponse();
                        break;
                    }
                    case 50: {
                        this.handleData();
                        break;
                    }
                    case 80: {
                        this.handlePingRequest();
                        break;
                    }
                    case 81: {
                        this.handlePingResponse();
                        break;
                    }
                    case 96: {
                        this.handleFlowRead();
                        break;
                    }
                    case 112: {
                        this.handleShutdown();
                        break;
                    }
                    default: {
                        throw new IOException("Unrecognised message type: " + type);
                    }
                }
            }
            catch (Exception exception) {
                boolean closed = this._closed;
                this.shutdown();
                if (closed) break block13;
                _log.debug((Object)"Multiplexer shutting down on error", (Throwable)exception);
                this._listener.error(exception);
            }
        }
    }

    private void shutdown() {
        Channel[] channels;
        this._closed = true;
        HashMap hashMap = this._channels;
        synchronized (hashMap) {
            channels = this._channels.values().toArray(new Channel[0]);
        }
        int i = 0;
        while (i < channels.length) {
            channels[i].disconnected();
            ++i;
        }
        try {
            this._endpoint.close();
        }
        catch (IOException exception) {
            _log.debug((Object)exception);
        }
    }

    private void handleOpen() throws IOException {
        int channelId = this._in.readUnsignedShort();
        Integer key = new Integer(channelId);
        HashMap hashMap = this._channels;
        synchronized (hashMap) {
            if (this._channels.get(key) != null) {
                throw new IOException("A channel already exists with identifier: " + key);
            }
            this.addChannel(channelId);
        }
    }

    private void handleClose() throws IOException {
        int channelId = this._in.readUnsignedShort();
        Integer key = new Integer(channelId);
        HashMap hashMap = this._channels;
        synchronized (hashMap) {
            Channel channel = (Channel)this._channels.remove(key);
            if (channel == null) {
                throw new IOException("No channel exists with identifier: " + key);
            }
            channel.close();
        }
    }

    private void handleRequest() throws IOException {
        Channel channel = this.handleData();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("handleRequest() [channel=" + channel.getId() + "]"));
        }
        this._listener.request(channel);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("handleRequest() [channel=" + channel.getId() + "] - end"));
        }
    }

    private void handleResponse() throws IOException {
        this.handleData();
    }

    private void handlePingRequest() throws IOException {
        int token = this._in.readInt();
        DataOutputStream dataOutputStream = this._out;
        synchronized (dataOutputStream) {
            this._out.writeByte(81);
            this._out.writeInt(token);
            this._out.flush();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("pinged(token=" + token + ")"));
            }
        }
    }

    private void handlePingResponse() throws IOException {
        int token = this._in.readInt();
        this._listener.pinged(token);
    }

    private Channel handleData() throws IOException {
        Channel channel = this.readChannel();
        int length = this._in.readInt();
        channel.getMultiplexInputStream().receive(this._in, length);
        return channel;
    }

    private void handleFlowRead() throws IOException {
        Channel channel = this.readChannel();
        int read = this._in.readInt();
        channel.getMultiplexOutputStream().notifyRead(read);
    }

    private void handleShutdown() {
        this.shutdown();
        this._listener.closed();
    }

    private Channel addChannel(int channelId) {
        int size = 2048;
        MultiplexOutputStream out = new MultiplexOutputStream(channelId, this, size, size);
        MultiplexInputStream in = new MultiplexInputStream(channelId, this, size);
        Channel channel = new Channel(channelId, this, in, out);
        this._channels.put(new Integer(channelId), channel);
        return channel;
    }

    private Channel readChannel() throws IOException {
        int channelId = this._in.readUnsignedShort();
        return this.getChannel(channelId);
    }

    private Channel getChannel(int channelId) throws IOException {
        Channel channel;
        Integer key = new Integer(channelId);
        HashMap hashMap = this._channels;
        synchronized (hashMap) {
            channel = (Channel)this._channels.get(key);
            if (channel == null) {
                throw new IOException("No channel exists with identifier: " + channelId);
            }
        }
        return channel;
    }

    private int getNextChannelId() throws IOException {
        int mask = Short.MAX_VALUE;
        int serverIdBase = 32768;
        int channelId = 0;
        while (!this._closed) {
            this._seed = this._seed + 1 & Short.MAX_VALUE;
            int n = channelId = this._client ? this._seed : this._seed + 32768;
            if (!this._channels.containsKey(new Integer(channelId))) break;
        }
        if (this._closed) {
            throw new IOException("Connection has been closed");
        }
        return channelId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

