/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.multiplexer;

import java.io.IOException;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.AbstractManagedConnection;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerImpl;
import org.exolab.jms.net.connector.ConnectException;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.IllegalStateException;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnectionListener;
import org.exolab.jms.net.connector.Request;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.Response;
import org.exolab.jms.net.connector.SecurityException;
import org.exolab.jms.net.multiplexer.Channel;
import org.exolab.jms.net.multiplexer.ChannelInvocation;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.multiplexer.MultiplexedConnection;
import org.exolab.jms.net.multiplexer.Multiplexer;
import org.exolab.jms.net.multiplexer.MultiplexerListener;
import org.exolab.jms.net.uri.URI;

public abstract class MultiplexedManagedConnection
extends AbstractManagedConnection
implements MultiplexerListener {
    private Multiplexer _multiplexer;
    private Thread _multiplexThread;
    private Endpoint _endpoint;
    private InvocationHandler _invoker;
    private Principal _principal;
    private Authenticator _authenticator;
    private Caller _caller;
    private ThreadGroup _group;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$multiplexer$MultiplexedManagedConnection == null ? (class$org$exolab$jms$net$multiplexer$MultiplexedManagedConnection = MultiplexedManagedConnection.class$("org.exolab.jms.net.multiplexer.MultiplexedManagedConnection")) : class$org$exolab$jms$net$multiplexer$MultiplexedManagedConnection));
    static /* synthetic */ Class class$org$exolab$jms$net$multiplexer$MultiplexedManagedConnection;

    public MultiplexedManagedConnection(Principal principal) {
        this._principal = principal;
    }

    public MultiplexedManagedConnection(Authenticator authenticator) {
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        this._authenticator = authenticator;
    }

    public void setInvocationHandler(InvocationHandler handler) throws ResourceException {
        if (this._invoker != null) {
            throw new IllegalStateException("An invocation handler is already registered");
        }
        this._invoker = handler;
        try {
            this._endpoint = this.createEndpoint();
            if (this.isClient()) {
                this._multiplexer = this.createMultiplexer(this._endpoint, this._principal);
            } else {
                this._multiplexer = this.createMultiplexer(this._endpoint, this._authenticator);
                this._principal = this._multiplexer.getPrincipal();
                this._caller = new CallerImpl(this.getRemoteURI(), this.getLocalURI());
            }
            String name = this.getDisplayName() + "-Multiplexer";
            this._multiplexThread = new Thread(this.getThreadGroup(), this._multiplexer, name);
            this._multiplexThread.start();
        }
        catch (IOException exception) {
            throw new ConnectException("Failed to start multiplexer", exception);
        }
    }

    public synchronized Connection getConnection() throws IllegalStateException {
        if (this._invoker == null) {
            throw new IllegalStateException("No InvocationHandler registered");
        }
        return new MultiplexedConnection(this);
    }

    public void ping() throws ResourceException {
        Multiplexer multiplexer;
        MultiplexedManagedConnection multiplexedManagedConnection = this;
        synchronized (multiplexedManagedConnection) {
            multiplexer = this._multiplexer;
        }
        if (multiplexer != null) {
            try {
                multiplexer.ping(0);
            }
            catch (IOException exception) {
                throw new ResourceException(exception.getMessage(), exception);
            }
        } else {
            throw new IllegalStateException("Connection not established");
        }
    }

    public void destroy() throws ResourceException {
        MultiplexedManagedConnection multiplexedManagedConnection;
        Endpoint endpoint;
        Thread thread;
        Multiplexer multiplexer;
        MultiplexedManagedConnection multiplexedManagedConnection2 = this;
        synchronized (multiplexedManagedConnection2) {
            multiplexer = this._multiplexer;
            thread = this._multiplexThread;
            endpoint = this._endpoint;
        }
        try {
            if (multiplexer != null) {
                multiplexer.close();
                if (thread != Thread.currentThread()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException exception) {
                        _log.debug((Object)exception);
                    }
                }
            } else if (endpoint != null) {
                try {
                    endpoint.close();
                }
                catch (IOException exception) {
                    throw new ResourceException("Failed to close endpoint", exception);
                }
            }
            Object var7_8 = null;
            multiplexedManagedConnection = this;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            MultiplexedManagedConnection multiplexedManagedConnection3 = this;
            synchronized (multiplexedManagedConnection3) {
                this._multiplexer = null;
                this._multiplexThread = null;
                this._endpoint = null;
            }
            throw throwable;
        }
        synchronized (multiplexedManagedConnection) {
            this._multiplexer = null;
            this._multiplexThread = null;
            this._endpoint = null;
        }
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean hasPrincipal(Principal principal) {
        boolean result = false;
        if (this._principal != null && this._principal.equals(principal) || this._principal == null && principal == null) {
            result = true;
        }
        return result;
    }

    public void request(Channel channel) {
        this._invoker.invoke(new ChannelInvocation(channel, this.getCaller()));
    }

    public void closed() {
        this.notifyClosed();
    }

    public void error(Throwable error) {
        this.notifyError(error);
    }

    public void pinged(int token) {
        ManagedConnectionListener listener = this.getConnectionEventListener();
        if (listener != null) {
            listener.pinged(this);
        }
    }

    protected Response invoke(Connection connection, Request request) {
        Response response;
        Multiplexer multiplexer;
        MultiplexedManagedConnection multiplexedManagedConnection = this;
        synchronized (multiplexedManagedConnection) {
            multiplexer = this._multiplexer;
        }
        if (multiplexer != null) {
            Channel channel = null;
            try {
                channel = multiplexer.getChannel();
                response = channel.invoke(request);
                channel.release();
            }
            catch (Exception exception) {
                _log.debug((Object)exception, (Throwable)exception);
                response = new Response(exception);
                if (channel != null) {
                    channel.destroy();
                }
            }
        } else {
            response = new Response(new ResourceException("Connection lost"));
        }
        return response;
    }

    protected abstract Endpoint createEndpoint() throws IOException;

    protected Multiplexer createMultiplexer(Endpoint endpoint, Principal principal) throws IOException, SecurityException {
        return new Multiplexer((MultiplexerListener)this, endpoint, principal);
    }

    protected Multiplexer createMultiplexer(Endpoint endpoint, Authenticator authenticator) throws IOException, ResourceException {
        return new Multiplexer((MultiplexerListener)this, endpoint, authenticator);
    }

    protected boolean isClient() {
        return this._authenticator == null;
    }

    protected Caller getCaller() {
        return this._caller;
    }

    protected synchronized ThreadGroup getThreadGroup() {
        if (this._group == null) {
            this._group = new ThreadGroup(this.getDisplayName());
        }
        return this._group;
    }

    protected String getDisplayName() {
        URI uri;
        StringBuffer name;
        block6: {
            name = new StringBuffer();
            uri = null;
            try {
                uri = this.getRemoteURI();
            }
            catch (ResourceException ignore) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)"Failed to determine remote URI", (Throwable)ignore);
            }
        }
        if (uri != null) {
            name.append(uri.toString());
        } else {
            name.append("<unknown>");
        }
        if (this.isClient()) {
            name.append("[client]");
        } else {
            name.append("[server]");
        }
        return name.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

