/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.multiplexer;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.multiplexer.Constants;
import org.exolab.jms.net.multiplexer.Multiplexer;

class MultiplexOutputStream
extends OutputStream
implements Constants {
    private final int _channelId;
    private byte _type;
    private Multiplexer _multiplexer;
    private byte[] _data;
    private int _index;
    private int _remoteSpace;
    private final int _maxRemoteSpace;
    private boolean _disconnected;
    private final Object _lock = new Object();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$multiplexer$MultiplexOutputStream == null ? (class$org$exolab$jms$net$multiplexer$MultiplexOutputStream = MultiplexOutputStream.class$("org.exolab.jms.net.multiplexer.MultiplexOutputStream")) : class$org$exolab$jms$net$multiplexer$MultiplexOutputStream));
    static /* synthetic */ Class class$org$exolab$jms$net$multiplexer$MultiplexOutputStream;

    public MultiplexOutputStream(int channelId, Multiplexer multiplexer, int size, int remoteSize) {
        this._channelId = channelId;
        this._multiplexer = multiplexer;
        this._data = new byte[size];
        this._maxRemoteSpace = remoteSize;
        this._remoteSpace = remoteSize;
    }

    public void setType(byte type) {
        this._type = type;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        int offset = 0;
        int length = this._index;
        while (offset < this._index) {
            int available = this.waitForSpace();
            int size = length <= available ? length : available;
            this.send(this._data, offset, size);
            offset += size;
            length -= size;
        }
        this._index = 0;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        int space = this._data.length - this._index;
        if (space >= length) {
            System.arraycopy(buffer, offset, this._data, this._index, length);
            this._index += length;
        } else {
            this.flush();
            int size = length;
            while (size > 0) {
                int available = this.waitForSpace();
                int count = size <= available ? size : available;
                this.send(buffer, offset, count);
                offset += count;
                size -= count;
            }
        }
    }

    public void write(int value) throws IOException {
        if (this._index >= this._data.length) {
            this.flush();
        }
        this._data[this._index++] = (byte)value;
    }

    public void notifyRead(int read) throws IOException {
        Object object = this._lock;
        synchronized (object) {
            int space = this._remoteSpace + read;
            if (space > this._maxRemoteSpace) {
                throw new IOException("Remote space=" + space + " exceeds expected space=" + this._maxRemoteSpace);
            }
            this._remoteSpace = space;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("notifyRead(read=" + read + ") [channelId=" + this._channelId + ", remoteSpace=" + this._remoteSpace + "]"));
            }
            this._lock.notifyAll();
        }
    }

    public void disconnected() {
        Object object = this._lock;
        synchronized (object) {
            this._disconnected = true;
            this._lock.notifyAll();
        }
    }

    public String toString() {
        return "MultiplexOutputStream[index=" + this._index + "]";
    }

    private void send(byte[] buffer, int offset, int length) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("send(length=" + length + ") [channelId=" + this._channelId + ", remoteSpace=" + this._remoteSpace + "]"));
        }
        Object object = this._lock;
        synchronized (object) {
            this._multiplexer.send(this._type, this._channelId, buffer, offset, length);
            this._type = (byte)50;
            this._remoteSpace -= length;
        }
    }

    private int waitForSpace() throws IOException {
        int available = 0;
        while (!this._disconnected) {
            Object object = this._lock;
            synchronized (object) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("waitForSpace() [channelId=" + this._channelId + ", remoteSpace=" + this._remoteSpace + "]"));
                }
                if (this._remoteSpace > 0) {
                    available = this._remoteSpace;
                    break;
                }
                try {
                    this._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this._disconnected) {
            throw new IOException("Connection has been closed");
        }
        return available;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

