/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.multiplexer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.multiplexer.Constants;
import org.exolab.jms.net.multiplexer.Multiplexer;

class MultiplexInputStream
extends InputStream
implements Constants {
    private final int _channelId;
    private Multiplexer _multiplexer;
    private byte[] _data;
    private byte[] _byte = new byte[1];
    private int _index = 0;
    private int _available = 0;
    private boolean _disconnected = false;
    private final int _lowWaterMark;
    private int _read = 0;
    private final Object _lock = new Object();
    private final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$multiplexer$MultiplexInputStream == null ? (class$org$exolab$jms$net$multiplexer$MultiplexInputStream = MultiplexInputStream.class$("org.exolab.jms.net.multiplexer.MultiplexInputStream")) : class$org$exolab$jms$net$multiplexer$MultiplexInputStream));
    static /* synthetic */ Class class$org$exolab$jms$net$multiplexer$MultiplexInputStream;

    public MultiplexInputStream(int channelId, Multiplexer multiplexer, int size) {
        this._channelId = channelId;
        this._multiplexer = multiplexer;
        this._data = new byte[size];
        this._lowWaterMark = size / 2;
    }

    public void close() {
    }

    public void destroy() throws IOException {
        Object object = this._lock;
        synchronized (object) {
            if (!this._disconnected) {
                // empty if block
            }
        }
        this._multiplexer = null;
        this._data = null;
    }

    public int read() throws IOException {
        int mask = 255;
        int count = this.read(this._byte, 0, 1);
        return count == 1 ? this._byte[0] & 0xFF : -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int count = 0;
        if (length > 0) {
            Object object = this._lock;
            synchronized (object) {
                int n = count = length <= this._available ? length : this._available;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("read(length=" + length + ") [channelId=" + this._channelId + ", available=" + this._available + "]"));
                }
                if (count > 0) {
                    this.copy(buffer, offset, count);
                }
                if (count < length) {
                    int more = length - count;
                    while (this._available < more && !this._disconnected) {
                        if (this._log.isDebugEnabled()) {
                            this._log.debug((Object)("read() waiting on data [channelId=" + this._channelId + ", available=" + this._available + ", requested=" + more + "]"));
                        }
                        try {
                            this._lock.wait();
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                    if (this._available > 0) {
                        more = more <= this._available ? more : this._available;
                        this.copy(buffer, offset += count, more);
                        count += more;
                    }
                }
                if (count == 0 && this._disconnected) {
                    count = -1;
                }
            }
        }
        return count;
    }

    public int available() {
        int result;
        Object object = this._lock;
        synchronized (object) {
            result = this._available;
        }
        return result;
    }

    public void disconnected() {
        Object object = this._lock;
        synchronized (object) {
            this._disconnected = true;
            this._lock.notifyAll();
        }
    }

    public String toString() {
        return "MultiplexInputStream[available=" + this._available + "]";
    }

    protected void receive(DataInputStream input, int length) throws IOException {
        Object object = this._lock;
        synchronized (object) {
            int space = this._data.length - this._available;
            if (length > space) {
                throw new IOException("Buffer overflow: buffer size=" + this._data.length + ", space available=" + space + ", requested size=" + length);
            }
            int freeAtEnd = this._data.length - (this._index + this._available);
            if (length > freeAtEnd) {
                System.arraycopy(this._data, this._index, this._data, 0, this._available);
                this._index = 0;
            }
            input.readFully(this._data, this._index + this._available, length);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("receive(length=" + length + ") [channelId=" + this._channelId + ", available=" + this._available + ", space=" + (this._data.length - this._available) + "]"));
            }
            this._available += length;
            this._lock.notifyAll();
        }
    }

    private void copy(byte[] buffer, int offset, int length) throws IOException {
        System.arraycopy(this._data, this._index, buffer, offset, length);
        this._index += length;
        this._available -= length;
        this._read += length;
        if (this._read >= this._lowWaterMark) {
            this.notifyRead();
        }
    }

    private void notifyRead() throws IOException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("notifyRead() [channelId=" + this._channelId + ", read=" + this._read + "]"));
        }
        this._multiplexer.send((byte)96, this._channelId, this._read);
        this._read = 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

