/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.URIRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;
import org.exolab.jms.net.util.SSLProperties;

public class HTTPRequestInfo
extends URIRequestInfo {
    private String _proxyHost;
    private int _proxyPort;
    private String _proxyUser;
    private String _proxyPassword;
    private SSLProperties _sslProperties;
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_USER = "proxyUser";
    private static final String PROXY_PASSWORD = "proxyPassword";

    public HTTPRequestInfo(URI uri) {
        super(uri);
    }

    public HTTPRequestInfo(URI uri, Properties properties) throws ResourceException {
        super(uri);
        this.setProxyHost(properties.get(PROXY_HOST));
        this.setProxyPort(properties.getInt(PROXY_PORT, 0));
        this.setProxyUser(properties.get(PROXY_USER));
        this.setProxyPassword(properties.get(PROXY_PASSWORD));
        SSLProperties ssl = new SSLProperties(properties);
        if (!ssl.isEmpty()) {
            this.setSSLProperties(ssl);
        }
    }

    public void setProxyHost(String host) {
        this._proxyHost = host;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyPort(int port) {
        this._proxyPort = port;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyUser(String user) {
        this._proxyUser = user;
    }

    public String getProxyUser() {
        return this._proxyUser;
    }

    public void setProxyPassword(String pwd) {
        this._proxyPassword = pwd;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public SSLProperties getSSLProperties() {
        return this._sslProperties;
    }

    public void setSSLProperties(SSLProperties properties) {
        this._sslProperties = properties;
    }

    public void export(Properties properties) {
        super.export(properties);
        properties.setNonNull(PROXY_HOST, this.getProxyHost());
        properties.set(PROXY_PORT, this.getProxyPort());
        properties.setNonNull(PROXY_USER, this.getProxyUser());
        properties.setNonNull(PROXY_PASSWORD, this.getProxyPassword());
        SSLProperties ssl = this.getSSLProperties();
        if (ssl != null) {
            ssl.export(properties);
        }
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof HTTPRequestInfo && super.equals(other)) {
            HTTPRequestInfo info = (HTTPRequestInfo)other;
            if (this.equals(this._proxyHost, info._proxyHost) && this._proxyPort == info._proxyPort && this.equals(this._proxyUser, info._proxyUser) && this.equals(this._proxyPassword, info._proxyPassword) && this.equals(this._sslProperties, info._sslProperties)) {
                equal = true;
            }
        }
        return equal;
    }

    private boolean equals(Object o1, Object o2) {
        boolean equal;
        boolean bl = equal = o1 == null && o2 == null;
        if (!equal && o1 != null && o1.equals(o2)) {
            equal = true;
        }
        return equal;
    }
}

