/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Principal;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.SecurityException;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.multiplexer.Multiplexer;
import org.exolab.jms.net.multiplexer.MultiplexerListener;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

class HTTPMultiplexer
extends Multiplexer {
    private URI _clientURI;

    public HTTPMultiplexer(MultiplexerListener listener, Endpoint endpoint, URI clientURI, Principal principal) throws IOException, SecurityException {
        if (clientURI == null) {
            throw new IllegalArgumentException("Argument 'clientURI' is null");
        }
        this._clientURI = clientURI;
        this.initialise(listener, endpoint, true);
        this.authenticate(principal);
    }

    public HTTPMultiplexer(MultiplexerListener listener, Endpoint endpoint, Authenticator authenticator) throws IOException, ResourceException {
        super(listener, endpoint, authenticator);
    }

    public URI getClientURI() {
        return this._clientURI;
    }

    protected void handshake(DataOutputStream out, DataInputStream in) throws IOException {
        super.handshake(out, in);
        if (this.isClient()) {
            out.writeUTF(this._clientURI.toString());
        } else {
            String uri = in.readUTF();
            this._clientURI = URIHelper.parse(uri);
        }
    }
}

