/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.http;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.uuid.UUIDGenerator;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ConnectException;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.connector.SecurityException;
import org.exolab.jms.net.http.HTTPEndpoint;
import org.exolab.jms.net.http.HTTPMultiplexer;
import org.exolab.jms.net.http.HTTPRequestInfo;
import org.exolab.jms.net.multiplexer.Endpoint;
import org.exolab.jms.net.multiplexer.MultiplexedManagedConnection;
import org.exolab.jms.net.multiplexer.Multiplexer;
import org.exolab.jms.net.multiplexer.MultiplexerListener;
import org.exolab.jms.net.socket.SocketEndpoint;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

abstract class AbstractHTTPManagedConnection
extends MultiplexedManagedConnection {
    protected Endpoint _endpoint;
    private URI _remoteURI;
    private URI _localURI;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$http$AbstractHTTPManagedConnection == null ? (class$org$exolab$jms$net$http$AbstractHTTPManagedConnection = AbstractHTTPManagedConnection.class$("org.exolab.jms.net.http.AbstractHTTPManagedConnection")) : class$org$exolab$jms$net$http$AbstractHTTPManagedConnection));
    static /* synthetic */ Class class$org$exolab$jms$net$http$AbstractHTTPManagedConnection;

    public AbstractHTTPManagedConnection(Principal principal, HTTPRequestInfo info) throws ResourceException {
        super(principal);
        if (info == null) {
            throw new IllegalArgumentException("Argument 'info' is null");
        }
        URI uri = info.getURI();
        try {
            this._endpoint = new HTTPEndpoint(info);
        }
        catch (IOException exception) {
            _log.debug((Object)exception, (Throwable)exception);
            throw new ConnectException("Failed to connect to URI=" + info.getURI(), exception);
        }
        this._remoteURI = URIHelper.convertHostToAddress(uri);
        try {
            this._localURI = URIHelper.create(uri.getScheme(), null, -1, UUIDGenerator.create());
        }
        catch (InvalidURIException exception) {
            _log.debug((Object)exception, (Throwable)exception);
            throw new ResourceException("Failed to generate local URI", exception);
        }
    }

    public AbstractHTTPManagedConnection(URI uri, Socket socket, Authenticator authenticator) throws ResourceException {
        super(authenticator);
        if (uri == null) {
            throw new IllegalArgumentException("Argument 'uri' is null");
        }
        if (socket == null) {
            throw new IllegalArgumentException("Argument 'socket' is null");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        String scheme = uri.getScheme();
        int localPort = socket.getLocalPort();
        try {
            this._localURI = URIHelper.create(scheme, uri.getHost(), localPort);
        }
        catch (InvalidURIException exception) {
            _log.debug((Object)exception, (Throwable)exception);
            throw new ResourceException("Failed to generate local URI", exception);
        }
        try {
            this._endpoint = new SocketEndpoint(scheme, socket);
        }
        catch (IOException exception) {
            _log.debug((Object)exception, (Throwable)exception);
            throw new ResourceException("Failed to create endpoint", exception);
        }
    }

    public URI getRemoteURI() {
        return this._remoteURI;
    }

    public URI getLocalURI() {
        return this._localURI;
    }

    protected Endpoint createEndpoint() throws IOException {
        return this._endpoint;
    }

    protected Multiplexer createMultiplexer(Endpoint endpoint, Principal principal) throws IOException, SecurityException {
        return new HTTPMultiplexer(this, endpoint, this._localURI, principal);
    }

    protected Multiplexer createMultiplexer(Endpoint endpoint, Authenticator authenticator) throws IOException, ResourceException {
        HTTPMultiplexer result = new HTTPMultiplexer((MultiplexerListener)this, endpoint, authenticator);
        this._remoteURI = result.getClientURI();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

