/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.server.ObjID;
import org.exolab.jms.net.util.SerializationHelper;

public class Request
implements Serializable {
    private transient String _uri;
    private ObjID _objID;
    private transient Method _method;
    private transient ObjectInput _argStream;
    private Object[] _args;
    private long _methodID;

    public Request(ObjID objID, Method method, Object[] args, long methodID) {
        this._objID = objID;
        this._method = method;
        this._args = args;
        this._methodID = methodID;
    }

    private Request(String uri, ObjID objID, long methodID, ObjectInput argStream) {
        this._uri = uri;
        this._objID = objID;
        this._argStream = argStream;
        this._methodID = methodID;
    }

    public String getURI() {
        return this._uri;
    }

    public ObjID getObjID() {
        return this._objID;
    }

    public Method getMethod() {
        return this._method;
    }

    public Object[] getArgs() {
        return this._args;
    }

    public Object[] readArgs(Method method) throws ClassNotFoundException, IOException {
        Class<?>[] types = method.getParameterTypes();
        this._args = new Object[types.length];
        this._method = method;
        int i = 0;
        while (i < types.length) {
            this._args[i] = SerializationHelper.read(types[i], this._argStream);
            ++i;
        }
        if (this._argStream != null) {
            this._argStream.close();
            this._argStream = null;
        }
        return this._args;
    }

    public long getMethodID() {
        return this._methodID;
    }

    public void write(ObjectOutput out) throws IOException {
        this._objID.write(out);
        out.writeLong(this._methodID);
        Class<?>[] types = this._method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            SerializationHelper.write(types[i], this._args[i], out);
            ++i;
        }
    }

    public static Request read(ObjectInput in) throws IOException {
        ObjID objID = ObjID.read(in);
        long methodID = in.readLong();
        return new Request(null, objID, methodID, in);
    }
}

