/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.uri.InvalidURIException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.uri.URIHelper;

public class MulticastCallerListener
implements CallerListener {
    private Map _listeners = Collections.synchronizedMap(new HashMap());
    private static final CallerListener[] EMPTY = new CallerListener[0];

    public void addCallerListener(String uri, CallerListener listener) throws InvalidURIException {
        URI parsed = URIHelper.parse(uri);
        parsed = URIHelper.convertHostToAddress(parsed);
        List<CallerListener> list = null;
        Map map = this._listeners;
        synchronized (map) {
            list = (List<CallerListener>)this._listeners.get(parsed);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                this._listeners.put(parsed, list);
            }
        }
        list.add(listener);
    }

    public void removeCallerListener(String uri, CallerListener listener) throws InvalidURIException {
        URI parsed = URIHelper.parse(uri);
        parsed = URIHelper.convertHostToAddress(parsed);
        List list = null;
        Map map = this._listeners;
        synchronized (map) {
            list = (List)this._listeners.get(parsed);
            if (list != null) {
                list.remove(listener);
            }
        }
    }

    public void disconnected(Caller caller) {
        CallerListener[] listeners = this.getListeners(caller.getRemoteURI());
        int i = 0;
        while (i < listeners.length) {
            listeners[i].disconnected(caller);
            ++i;
        }
    }

    private CallerListener[] getListeners(URI uri) {
        CallerListener[] result = EMPTY;
        List list = null;
        Map map = this._listeners;
        synchronized (map) {
            list = (List)this._listeners.get(uri);
            if (list == null) {
                list = (List)this._listeners.get(uri);
            }
        }
        if (list != null) {
            result = list.toArray(EMPTY);
        }
        return result;
    }
}

