/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.CallerImpl;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionPool;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.ContextInvocationHandler;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionAcceptorListener;
import org.exolab.jms.net.connector.ManagedConnectionFactory;
import org.exolab.jms.net.connector.ManagedConnectionHandle;
import org.exolab.jms.net.connector.ManagedConnectionListener;
import org.exolab.jms.net.connector.PoolEntry;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;

class DefaultConnectionPool
implements ManagedConnectionAcceptorListener,
ManagedConnectionListener,
ConnectionPool {
    private final ManagedConnectionFactory _factory;
    private final InvocationHandler _handler;
    private final ConnectionFactory _resolver;
    private List _connections = Collections.synchronizedList(new ArrayList());
    private Map _handles = Collections.synchronizedMap(new HashMap());
    private List _acceptors = Collections.synchronizedList(new ArrayList());
    private List _accepted = Collections.synchronizedList(new ArrayList());
    private Map _entries = Collections.synchronizedMap(new HashMap());
    private final Object _reapLock = new Object();
    private ClockDaemon _daemon;
    private final long _reapInterval;
    private final int _reapDeadIterations;
    private final long _idlePeriod;
    private volatile CallerListener _listener;
    private static final String POOL_PREFIX = "org.exolab.jms.net.pool.";
    private static final String DEAD_ITERATIONS = "reapDeadIterations";
    private static final String REAP_INTERVAL = "reapInterval";
    private static final String IDLE_PERIOD = "idlePeriod";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$net$connector$DefaultConnectionPool == null ? (class$org$exolab$jms$net$connector$DefaultConnectionPool = DefaultConnectionPool.class$("org.exolab.jms.net.connector.DefaultConnectionPool")) : class$org$exolab$jms$net$connector$DefaultConnectionPool));
    static /* synthetic */ Class class$org$exolab$jms$net$connector$DefaultConnectionPool;

    public DefaultConnectionPool(ManagedConnectionFactory factory, InvocationHandler handler, ConnectionFactory resolver, Map properties) throws ResourceException {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Argument 'resolver' is null");
        }
        this._factory = factory;
        this._handler = handler;
        this._resolver = resolver;
        Properties config = new Properties(properties, POOL_PREFIX);
        this._reapInterval = this.getPropertyMillis(config, REAP_INTERVAL, 60);
        this._reapDeadIterations = config.getInt(DEAD_ITERATIONS, 5);
        this._idlePeriod = this.getPropertyMillis(config, IDLE_PERIOD, 5);
    }

    private long getPropertyMillis(Properties config, String key, int defaultValue) throws ResourceException {
        int seconds = config.getInt(key, defaultValue);
        if (seconds < 0) {
            seconds = 0;
        }
        return seconds * 1000;
    }

    public ManagedConnection createManagedConnection(Principal principal, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnection connection = this._factory.createManagedConnection(principal, info);
        return this.add(connection, false);
    }

    public ManagedConnectionAcceptor createManagedConnectionAcceptor(Authenticator authenticator, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnectionAcceptor acceptor = this._factory.createManagedConnectionAcceptor(authenticator, info);
        this._acceptors.add(acceptor);
        return acceptor;
    }

    public ManagedConnection matchManagedConnections(Principal principal, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnection result;
        Object object = this._reapLock;
        synchronized (object) {
            result = this._factory.matchManagedConnections(this._connections, principal, info);
            result = result != null ? (ManagedConnection)this._handles.get(result) : this._factory.matchManagedConnections(this._accepted, principal, info);
        }
        return result;
    }

    public ManagedConnectionAcceptor matchManagedConnectionAcceptors(ConnectionRequestInfo info) throws ResourceException {
        return this._factory.matchManagedConnectionAcceptors(this._acceptors, info);
    }

    public ManagedConnectionAcceptorListener getManagedConnectionAcceptorListener() {
        return this;
    }

    public void accepted(ManagedConnectionAcceptor acceptor, ManagedConnection connection) {
        try {
            this.add(connection, true);
        }
        catch (ResourceException exception) {
            _log.debug((Object)"Failed to accept connection", (Throwable)exception);
        }
    }

    public void closed(ManagedConnection source) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Connection " + source + " closed by peer, destroying"));
        }
        this.remove(source);
    }

    public void error(ManagedConnection source, Throwable throwable) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Error on connection " + source + ", destroying"), throwable);
        }
        this.remove(source);
    }

    public void pinged(ManagedConnection source) {
        ManagedConnectionHandle handle = (ManagedConnectionHandle)this._handles.get(source);
        if (handle != null) {
            handle.pinged();
        }
    }

    public void close() throws ResourceException {
        ManagedConnectionAcceptor[] acceptors = this._acceptors.toArray(new ManagedConnectionAcceptor[0]);
        this._acceptors.clear();
        int i = 0;
        while (i < acceptors.length) {
            acceptors[i].close();
            ++i;
        }
        ManagedConnection[] connections = this._entries.keySet().toArray(new ManagedConnection[0]);
        int i2 = 0;
        while (i2 < connections.length) {
            connections[i2].destroy();
            ++i2;
        }
        this._entries.clear();
        this._accepted.clear();
        this._connections.clear();
        this.stopReaper();
    }

    public void error(ManagedConnectionAcceptor acceptor, Throwable throwable) {
        block4: {
            this._acceptors.remove(acceptor);
            String uri = "<unknown>";
            try {
                uri = acceptor.getURI().toString();
            }
            catch (ResourceException ignore) {
                // empty catch block
            }
            _log.error((Object)("Failed to accept connections on URI=" + uri), throwable);
            try {
                acceptor.close();
            }
            catch (ResourceException exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)("Failed to close acceptor, URI=" + uri), (Throwable)exception);
            }
        }
    }

    public void setCallerListener(CallerListener listener) {
        this._listener = listener;
    }

    protected synchronized void idle(ManagedConnectionHandle connection) {
        connection.clearUsed();
        if (this._daemon != null) {
            this._daemon.executeAfterDelay(this._idlePeriod, (Runnable)new IdleReaper());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ManagedConnection add(ManagedConnection connection, boolean accepted) throws ResourceException {
        ManagedConnection result;
        PoolEntry entry = new PoolEntry(connection, accepted);
        this._entries.put(connection, entry);
        if (accepted) {
            this._accepted.add(connection);
            result = connection;
        } else {
            this._connections.add(connection);
            ManagedConnectionHandle handle = new ManagedConnectionHandle(this, connection, this._resolver);
            this._handles.put(connection, handle);
            result = handle;
        }
        ContextInvocationHandler handler = new ContextInvocationHandler(this._handler, this._resolver, result);
        try {
            connection.setInvocationHandler(handler);
            connection.setConnectionEventListener(this);
        }
        catch (ResourceException exception) {
            try {
                try {
                    _log.debug((Object)"Failed to initialise connection, destroying", (Throwable)exception);
                    connection.destroy();
                }
                catch (ResourceException nested) {
                    _log.debug((Object)"Failed to destroy connection", (Throwable)nested);
                    Object var9_8 = null;
                    this._entries.remove(connection);
                    if (accepted) {
                        this._accepted.remove(connection);
                        throw exception;
                    }
                    this._connections.remove(connection);
                    this._handles.remove(connection);
                    throw exception;
                }
                Object var9_7 = null;
                this._entries.remove(connection);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this._entries.remove(connection);
                if (accepted) {
                    this._accepted.remove(connection);
                    throw throwable;
                }
                this._connections.remove(connection);
                this._handles.remove(connection);
                throw throwable;
            }
            if (accepted) {
                this._accepted.remove(connection);
                throw exception;
            }
            this._connections.remove(connection);
            this._handles.remove(connection);
            throw exception;
        }
        entry.setInitialised();
        this.startReaper();
        return result;
    }

    protected void remove(ManagedConnection connection) {
        PoolEntry entry = (PoolEntry)this._entries.remove(connection);
        if (entry != null) {
            if (entry.getAccepted()) {
                this._accepted.remove(connection);
            } else {
                this._connections.remove(connection);
                this._handles.remove(connection);
            }
            URI remoteURI = null;
            URI localURI = null;
            try {
                remoteURI = connection.getRemoteURI();
                localURI = connection.getLocalURI();
            }
            catch (ResourceException exception) {
                _log.debug((Object)"Failed to get connection URIs", (Throwable)exception);
            }
            try {
                connection.destroy();
            }
            catch (ResourceException exception) {
                _log.debug((Object)"Failed to destroy connection", (Throwable)exception);
            }
            if (remoteURI != null && localURI != null) {
                this.notifyDisconnection(remoteURI, localURI);
            }
        } else {
            _log.debug((Object)"ManagedConnection not found");
        }
        if (this._entries.isEmpty()) {
            this.stopReaper();
        }
    }

    private void notifyDisconnection(URI remoteURI, URI localURI) {
        CallerListener listener = this._listener;
        if (listener != null) {
            listener.disconnected(new CallerImpl(remoteURI, localURI));
        }
    }

    private synchronized void startReaper() {
        if (this._daemon == null) {
            this._daemon = new ClockDaemon();
            org.exolab.jms.common.threads.ThreadFactory creator = new org.exolab.jms.common.threads.ThreadFactory(null, "ManagedConnectionReaper", false);
            this._daemon.setThreadFactory((ThreadFactory)creator);
            if (this._reapInterval > 0L) {
                this._daemon.executePeriodically(this._reapInterval, (Runnable)new DeadReaper(), false);
            }
        }
    }

    private synchronized void stopReaper() {
        if (this._daemon != null) {
            this._daemon.shutDown();
            this._daemon = null;
        }
    }

    private void reapIdleConnections() {
        Map.Entry[] entries = this._handles.entrySet().toArray(new Map.Entry[0]);
        int i = 0;
        while (i < entries.length && !this.stopReaping()) {
            ManagedConnectionHandle handle;
            Map.Entry entry = entries[i];
            ManagedConnection connection = (ManagedConnection)entry.getKey();
            PoolEntry pooled = (PoolEntry)this._entries.get(connection);
            if (pooled != null && pooled.isInitialised() && (handle = (ManagedConnectionHandle)entry.getValue()).canDestroy()) {
                if (_log.isDebugEnabled()) {
                    try {
                        _log.debug((Object)("Reaping idle connection, URI=" + connection.getRemoteURI() + ", local URI=" + connection.getLocalURI()));
                    }
                    catch (ResourceException ignore) {
                        // empty catch block
                    }
                }
                this.remove(connection);
            }
            ++i;
        }
    }

    private void reapDeadConnections() {
        Map.Entry[] entries = this._handles.entrySet().toArray(new Map.Entry[0]);
        int i = 0;
        while (i < entries.length && !this.stopReaping()) {
            Map.Entry entry = entries[i];
            ManagedConnection connection = (ManagedConnection)entry.getKey();
            PoolEntry pooled = (PoolEntry)this._entries.get(connection);
            if (pooled != null && pooled.isInitialised()) {
                ManagedConnectionHandle handle = (ManagedConnectionHandle)entry.getValue();
                if (!handle.used()) {
                    if (handle.pinging()) {
                        if (handle.incPingWaits() > this._reapDeadIterations) {
                            this.remove(connection);
                        }
                    } else {
                        try {
                            handle.ping();
                        }
                        catch (ResourceException exception) {
                            if (_log.isDebugEnabled()) {
                                try {
                                    _log.debug((Object)("Failed to ping connection, URI=" + connection.getRemoteURI() + ", localURI=" + connection.getLocalURI()));
                                }
                                catch (ResourceException ignore) {
                                    // empty catch block
                                }
                            }
                            this.remove(connection);
                        }
                    }
                } else {
                    handle.clearUsed();
                }
            }
            ++i;
        }
    }

    private boolean stopReaping() {
        return Thread.currentThread().isInterrupted();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DeadReaper
    implements Runnable {
        private DeadReaper() {
        }

        public void run() {
            try {
                DefaultConnectionPool.this.reapDeadConnections();
            }
            catch (Throwable exception) {
                _log.error((Object)exception, exception);
            }
        }
    }

    private class IdleReaper
    implements Runnable {
        private IdleReaper() {
        }

        public void run() {
            Object object = DefaultConnectionPool.this._reapLock;
            synchronized (object) {
                try {
                    DefaultConnectionPool.this.reapIdleConnections();
                }
                catch (Throwable exception) {
                    _log.error((Object)exception, exception);
                }
            }
        }
    }
}

