/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.net.connector;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.connector.Connection;
import org.exolab.jms.net.connector.ConnectionFactory;
import org.exolab.jms.net.connector.ConnectionManager;
import org.exolab.jms.net.connector.ConnectionPool;
import org.exolab.jms.net.connector.ConnectionRequestInfo;
import org.exolab.jms.net.connector.DefaultConnectionPool;
import org.exolab.jms.net.connector.InvocationHandler;
import org.exolab.jms.net.connector.ManagedConnection;
import org.exolab.jms.net.connector.ManagedConnectionAcceptor;
import org.exolab.jms.net.connector.ManagedConnectionFactory;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.uri.URI;

public abstract class AbstractConnectionManager
implements ConnectionManager,
ConnectionFactory {
    private final Map _factories = new HashMap();
    private final InvocationHandler _handler;
    private final Authenticator _authenticator;
    private final Map _connectionFactories = new HashMap();
    private final Map _properties;
    private CallerListener _listener;

    public AbstractConnectionManager(InvocationHandler handler, Authenticator authenticator, Map properties) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        this._handler = handler;
        this._authenticator = authenticator;
        this._properties = properties;
    }

    public Connection allocateConnection(ManagedConnectionFactory factory, Principal principal, ConnectionRequestInfo info) throws ResourceException {
        ConnectionPool pool = this.getConnectionPool(factory);
        ManagedConnection connection = pool.matchManagedConnections(principal, info);
        if (connection == null) {
            connection = pool.createManagedConnection(principal, info);
        }
        return connection.getConnection();
    }

    public void accept(ManagedConnectionFactory factory, ConnectionRequestInfo info) throws ResourceException {
        ConnectionPool pool = this.getConnectionPool(factory);
        ManagedConnectionAcceptor acceptor = pool.matchManagedConnectionAcceptors(info);
        if (acceptor == null) {
            acceptor = pool.createManagedConnectionAcceptor(this._authenticator, info);
            acceptor.accept(pool.getManagedConnectionAcceptorListener());
        }
    }

    public boolean canConnect(URI uri) {
        ConnectionFactory factory = this.getFactoryForConnect(uri);
        return factory != null;
    }

    public Connection getConnection(Principal principal, URI uri) throws ResourceException {
        return this.getConnection(principal, uri, null);
    }

    public Connection getConnection(Principal principal, URI uri, Map properties) throws ResourceException {
        ConnectionFactory factory = this.getFactoryForConnect(uri);
        if (factory == null) {
            throw new ResourceException("No connector for URI=" + uri);
        }
        return factory.getConnection(principal, uri, properties);
    }

    public boolean canAccept(URI uri) {
        ConnectionFactory factory = this.getFactoryForAccept(uri);
        return factory != null;
    }

    public void accept(URI uri) throws ResourceException {
        this.accept(uri, null);
    }

    public void accept(URI uri, Map properties) throws ResourceException {
        ConnectionFactory factory = this.getFactoryForAccept(uri);
        if (factory == null) {
            throw new ResourceException("No connector for URI=" + uri);
        }
        factory.accept(uri, properties);
    }

    public synchronized void setCallerListener(CallerListener listener) {
        this._listener = listener;
        Iterator iterator = this._factories.values().iterator();
        while (iterator.hasNext()) {
            ConnectionPool pool = (ConnectionPool)iterator.next();
            pool.setCallerListener(this._listener);
        }
    }

    public synchronized void close() throws ResourceException {
        Iterator iterator = this._factories.values().iterator();
        while (iterator.hasNext()) {
            ConnectionPool pool = (ConnectionPool)iterator.next();
            pool.close();
        }
        this._factories.clear();
    }

    protected synchronized ConnectionFactory getFactoryForConnect(URI uri) {
        ConnectionFactory result = null;
        Iterator iterator = this._connectionFactories.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionFactory factory = (ConnectionFactory)iterator.next();
            if (!factory.canConnect(uri)) continue;
            result = factory;
            break;
        }
        return result;
    }

    protected synchronized ConnectionFactory getFactoryForAccept(URI uri) {
        ConnectionFactory result = null;
        Iterator iterator = this._connectionFactories.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionFactory factory = (ConnectionFactory)iterator.next();
            if (!factory.canAccept(uri)) continue;
            result = factory;
            break;
        }
        return result;
    }

    protected synchronized void addManagedConnectionFactory(ManagedConnectionFactory factory) throws ResourceException {
        ConnectionPool pool = this.createConnectionPool(factory, this._handler, this);
        pool.setCallerListener(this._listener);
        this._factories.put(factory, pool);
        this._connectionFactories.put(factory.createConnectionFactory(this), factory);
    }

    protected synchronized Collection getManagedConnectionFactories() {
        return this._factories.keySet();
    }

    protected ConnectionPool createConnectionPool(ManagedConnectionFactory factory, InvocationHandler handler, ConnectionFactory resolver) throws ResourceException {
        return new DefaultConnectionPool(factory, handler, resolver, this._properties);
    }

    protected synchronized ConnectionPool getConnectionPool(ManagedConnectionFactory factory) throws ResourceException {
        ConnectionPool pool = (ConnectionPool)this._factories.get(factory);
        if (pool == null) {
            throw new ResourceException("Connection pool not found");
        }
        return pool;
    }
}

