/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.migration.proxy.DBConstants;

public class PropertyStore
implements DBConstants {
    private final Map _properties = new HashMap();
    private final Connection _connection;

    public PropertyStore(Connection connection) throws PersistenceException {
        this._connection = connection;
        this.init();
    }

    public void add(String name, String value) throws PersistenceException {
        PreparedStatement insert = null;
        try {
            try {
                insert = this._connection.prepareStatement("insert into openjms_pprops values (?, ?)");
                insert.setString(1, name);
                insert.setString(2, value);
                insert.execute();
                this._properties.put(name, value);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to insert property, name=" + name + ", value=" + value, (Throwable)exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close((Statement)insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
    }

    public String get(String name) {
        return (String)this._properties.get(name);
    }

    private void init() throws PersistenceException {
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select name, value from openjms_pprops");
                set = select.executeQuery();
                while (set.next()) {
                    String name = set.getString(1);
                    String value = set.getString(2);
                    this._properties.put(name, value);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to load properties", (Throwable)exception);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
    }
}

