/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.exolab.jms.message.MapMessageImpl;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.proxy.AbstractMessageHandler;
import org.exolab.jms.tools.migration.proxy.DestinationStore;

class MapMessageHandler
extends AbstractMessageHandler {
    public MapMessageHandler(DestinationStore destinations, Connection connection) {
        super(destinations, connection);
    }

    protected String getType() {
        return "MapMessage";
    }

    protected Message newMessage() throws JMSException {
        return new MapMessageImpl();
    }

    protected void setBody(Object body, Message message) throws JMSException, PersistenceException {
        MapMessage map = (MapMessage)message;
        if (body != null) {
            if (!(body instanceof Map)) {
                throw new JMSException("Expected Map body for MapMessage with JMSMessageID=" + message.getJMSMessageID() + " but got type " + body.getClass().getName());
            }
            Map properties = (Map)body;
            Iterator iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                map.setObject(name, value);
            }
        }
    }

    protected Object getBody(Message message) throws JMSException {
        MapMessage map = (MapMessage)message;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration iterator = map.getMapNames();
        while (iterator.hasMoreElements()) {
            String name = (String)iterator.nextElement();
            properties.put(name, map.getObject(name));
        }
        return properties;
    }
}

