/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.proxy;

import java.util.ArrayList;
import java.util.List;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.tools.migration.proxy.Subscription;

public class Consumer {
    private final String _name;
    private final String _clientId;
    private final boolean _queueConsumer;
    private ArrayList _subscriptions = new ArrayList();

    public Consumer(JmsQueue queue) {
        this(queue.getName(), null, true);
    }

    public Consumer(String name, String clientId) {
        this(name, clientId, false);
    }

    private Consumer(String name, String clientId, boolean queueConsumer) {
        this._name = name;
        this._clientId = clientId;
        this._queueConsumer = queueConsumer;
    }

    public String getName() {
        return this._name;
    }

    public String getClientID() {
        return this._clientId;
    }

    public boolean isQueueConsumer() {
        return this._queueConsumer;
    }

    public void addSubscription(Subscription subscription) {
        if (this._queueConsumer) {
            if (!this._subscriptions.isEmpty()) {
                throw new IllegalStateException("Consumer cannot have multiple subscriptions");
            }
            if (!subscription.getDestination().getName().equals(this._name)) {
                throw new IllegalStateException("Queue consumer subscription mismatch");
            }
        }
        this._subscriptions.add(subscription);
    }

    public List getSubscriptions() {
        return this._subscriptions;
    }
}

