/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.master;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.JMSException;
import org.exolab.jms.authentication.User;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.IteratorAdapter;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;

public class MasterUserStore
implements Store {
    private DatabaseService _database;

    public MasterUserStore(DatabaseService database) {
        this._database = database;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        List users = this.getUsers();
        return new IteratorAdapter(users.iterator());
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        Connection connection = this._database.getConnection();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            this._database.getAdapter().addUser(connection, user);
        }
        this._database.commit();
    }

    public int size() throws PersistenceException {
        return this.getUsers().size();
    }

    private List getUsers() throws PersistenceException {
        ArrayList result = new ArrayList();
        Connection connection = this._database.getConnection();
        Enumeration users = this._database.getAdapter().getAllUsers(connection);
        while (users.hasMoreElements()) {
            result.add(users.nextElement());
        }
        this._database.commit();
        return result;
    }
}

