/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration.master;

import java.sql.Connection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.JMSException;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.MessageHandle;
import org.exolab.jms.messagemgr.PersistentMessageHandle;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceAdapter;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.proxy.Consumer;
import org.exolab.jms.tools.migration.proxy.MessageState;
import org.exolab.jms.tools.migration.proxy.Subscription;

public class MasterConsumerStore
implements Store {
    private DatabaseService _database;

    public MasterConsumerStore(DatabaseService database) {
        this._database = database;
    }

    public StoreIterator exportCollection() throws JMSException, PersistenceException {
        Collection consumers = this.getConsumers();
        return new ConsumerIterator(consumers);
    }

    public void importCollection(StoreIterator iterator) throws JMSException, PersistenceException {
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            this.add(consumer);
        }
    }

    public int size() throws PersistenceException {
        return this.getConsumers().size();
    }

    private Collection getConsumers() throws PersistenceException {
        Connection connection = this._database.getConnection();
        Enumeration destinations = this._database.getAdapter().getAllDestinations(connection);
        HashMap<String, Consumer> consumers = new HashMap<String, Consumer>();
        while (destinations.hasMoreElements()) {
            JmsDestination destination = (JmsDestination)destinations.nextElement();
            if (destination instanceof JmsTopic) {
                Enumeration names = this._database.getAdapter().getDurableConsumers(connection, destination.getName());
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    Consumer consumer = (Consumer)consumers.get(name);
                    if (consumer == null) {
                        consumer = new Consumer(name, null);
                        consumers.put(name, consumer);
                    }
                    Subscription subscription = this.getSubscription(name, destination);
                    consumer.addSubscription(subscription);
                }
                continue;
            }
            String name = destination.getName();
            Consumer consumer = (Consumer)consumers.get(name);
            if (consumer == null) {
                consumer = new Consumer((JmsQueue)destination);
                consumers.put(name, consumer);
            }
            Subscription subscription = this.getSubscription(name, destination);
            consumer.addSubscription(subscription);
        }
        this._database.commit();
        return consumers.values();
    }

    private Subscription getSubscription(String name, JmsDestination destination) throws PersistenceException {
        Subscription result = new Subscription(destination);
        Connection connection = this._database.getConnection();
        Vector handles = this._database.getAdapter().getMessageHandles(connection, destination, name);
        Iterator iterator = handles.iterator();
        while (iterator.hasNext()) {
            MessageHandle handle = (MessageHandle)iterator.next();
            String id = handle.getMessageId();
            result.addMessage(id, handle.getDelivered());
        }
        return result;
    }

    private void add(Consumer consumer) throws JMSException, PersistenceException {
        Iterator iterator = consumer.getSubscriptions().iterator();
        while (iterator.hasNext()) {
            Subscription subscription = (Subscription)iterator.next();
            this.add(consumer, subscription);
        }
    }

    private void add(Consumer consumer, Subscription subscription) throws JMSException, PersistenceException {
        String name = consumer.getName();
        JmsDestination destination = subscription.getDestination();
        Iterator iterator = subscription.getMessages().iterator();
        PersistenceAdapter adapter = this._database.getAdapter();
        Connection connection = this._database.getConnection();
        if (!consumer.isQueueConsumer()) {
            adapter.addDurableConsumer(connection, destination.getName(), name);
        }
        while (iterator.hasNext()) {
            MessageState state = (MessageState)iterator.next();
            MessageImpl message = adapter.getMessage(connection, state.getMessageId());
            PersistentMessageHandle handle = new PersistentMessageHandle(message.getJMSMessageID(), message.getJMSPriority(), message.getAcceptedTime(), message.getSequenceNumber(), message.getJMSExpiration(), destination, name);
            handle.setDelivered(state.getDelivered());
            handle.add();
        }
        this._database.commit();
    }

    private static class ConsumerIterator
    implements StoreIterator {
        private final Iterator _iterator;

        public ConsumerIterator(Collection consumers) {
            this._iterator = consumers.iterator();
        }

        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Object next() throws PersistenceException {
            return this._iterator.next();
        }
    }
}

