/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.migration;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationReader;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.RDBMSTool;
import org.exolab.jms.tools.migration.MigrationHelper;
import org.exolab.jms.tools.migration.Store;
import org.exolab.jms.tools.migration.StoreIterator;
import org.exolab.jms.tools.migration.master.MasterConsumerStore;
import org.exolab.jms.tools.migration.master.MasterDestinationStore;
import org.exolab.jms.tools.migration.master.MasterMessageStore;
import org.exolab.jms.tools.migration.master.MasterUserStore;
import org.exolab.jms.tools.migration.proxy.ConsumerStore;
import org.exolab.jms.tools.migration.proxy.DestinationStore;
import org.exolab.jms.tools.migration.proxy.MessageStore;
import org.exolab.jms.tools.migration.proxy.PropertyStore;
import org.exolab.jms.tools.migration.proxy.UserStore;
import org.exolab.jms.tools.migration.proxy.VersionInfo;
import org.exolab.jms.util.CommandLine;
import org.exolab.jms.util.Version;

public class Exporter {
    private final DatabaseService _database;
    private final EmbeddedDataSource _dataSource;
    private final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$migration$Exporter == null ? (class$org$exolab$jms$tools$migration$Exporter = Exporter.class$("org.exolab.jms.tools.migration.Exporter")) : class$org$exolab$jms$tools$migration$Exporter));
    static /* synthetic */ Class class$org$exolab$jms$tools$migration$Exporter;

    public Exporter(Configuration config, String database, boolean delete) throws PersistenceException {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        this._database = new DatabaseService(config);
        this._dataSource = MigrationHelper.getDataSource(database);
        this.init(delete);
    }

    public void apply() throws JMSException, PersistenceException, ServiceException {
        Connection connection;
        try {
            connection = this._dataSource.getConnection();
        }
        catch (SQLException exception) {
            throw new PersistenceException("Failed to get connection to target database", (Throwable)exception);
        }
        PropertyStore properties = new PropertyStore(connection);
        VersionInfo info = new VersionInfo(properties);
        info.setProxySchemaVersion("1.0");
        info.setOpenJMSVersion(Version.VERSION);
        info.setCreationTimestamp(System.currentTimeMillis());
        DestinationStore destinations = new DestinationStore(connection);
        ConsumerStore consumers = new ConsumerStore(destinations, connection);
        MessageStore messages = new MessageStore(destinations, connection);
        UserStore users = new UserStore(connection);
        this._database.start();
        this._log.info((Object)"Exporting destinations...");
        this.apply(new MasterDestinationStore(this._database), destinations);
        this._log.info((Object)("Exported " + destinations.size() + " destinations"));
        this._log.info((Object)"Exporting messages...");
        this.apply(new MasterMessageStore(this._database), messages);
        this._log.info((Object)("Exported " + messages.size() + " messages"));
        this._log.info((Object)"Exporting consumers...");
        this.apply(new MasterConsumerStore(this._database), consumers);
        this._log.info((Object)("Exported " + consumers.size() + " consumers"));
        this._log.info((Object)"Exporting users...");
        this.apply(new MasterUserStore(this._database), users);
        this._log.info((Object)("Exported " + users.size() + " users"));
        try {
            connection.close();
        }
        catch (SQLException exception) {
            throw new PersistenceException("Failed to close target", (Throwable)exception);
        }
        this._database.stop();
        this._dataSource.setShutdownDatabase("shutdown");
        this._log.info((Object)"Export complete");
    }

    public static void main(String[] args) {
        CommandLine commands = new CommandLine(args);
        String path = commands.value("config");
        if (path == null) {
            Exporter.usage();
            System.exit(1);
        } else {
            try {
                Configuration config = ConfigurationReader.read((String)path);
                String database = commands.value("db");
                if (database == null) {
                    database = "openjms_migdb";
                }
                boolean delete = commands.exists("delete");
                Exporter exporter = new Exporter(config, database, delete);
                exporter.apply();
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(boolean delete) throws PersistenceException {
        RDBMSTool tool;
        try {
            tool = new RDBMSTool(this._dataSource.getConnection());
        }
        catch (SQLException exception) {
            throw new PersistenceException((Throwable)exception);
        }
        try {
            Database schema = MigrationHelper.getSchema();
            if (tool.hasTables(schema.getTable())) {
                if (!delete) throw new PersistenceException("Cannot export data: migration database already exists but delete not specified");
                tool.delete(schema);
            } else {
                tool.create(schema);
            }
            Object var5_5 = null;
            tool.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            tool.close();
            throw throwable;
        }
    }

    private void apply(Store source, Store target) throws JMSException, PersistenceException {
        StoreIterator iterator = source.exportCollection();
        target.importCollection(iterator);
    }

    private static void usage() {
        System.err.println("usage: " + (class$org$exolab$jms$tools$migration$Exporter == null ? (class$org$exolab$jms$tools$migration$Exporter = Exporter.class$("org.exolab.jms.tools.migration.Exporter")) : class$org$exolab$jms$tools$migration$Exporter).getName() + " <arguments> [options]\n" + "arguments:\n" + "  -config <path>  specifies the path to an OpenJMS " + "configuration file\n" + "  -db <name>  specifies the path to export data to\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

