/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.db.Attribute;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.InvalidTypeException;
import org.exolab.jms.tools.db.RDBMSTool;
import org.exolab.jms.tools.db.SchemaBrowser;
import org.exolab.jms.tools.db.SchemaConverter;
import org.exolab.jms.tools.db.SchemaHelper;
import org.exolab.jms.tools.db.Table;
import org.exolab.jms.tools.db.Type;

public class V061toV072SchemaConverter
implements SchemaConverter {
    private Connection _connection;
    private RDBMSTool _tool;
    private static final String DESTINATIONS_TABLE = "destinations";
    private static final String ISQUEUE_COLUMN = "isQueue";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$db$migration$V061toV072SchemaConverter == null ? (class$org$exolab$jms$tools$db$migration$V061toV072SchemaConverter = V061toV072SchemaConverter.class$("org.exolab.jms.tools.db.migration.V061toV072SchemaConverter")) : class$org$exolab$jms$tools$db$migration$V061toV072SchemaConverter));
    static /* synthetic */ Class class$org$exolab$jms$tools$db$migration$V061toV072SchemaConverter;

    public V061toV072SchemaConverter(Connection connection) {
        this._connection = connection;
    }

    public void convert() throws PersistenceException {
        Database schema = SchemaHelper.getSchema();
        try {
            if (this._connection.getAutoCommit()) {
                this._connection.setAutoCommit(false);
            }
            this._tool = new RDBMSTool(this._connection);
        }
        catch (SQLException exception) {
            throw new PersistenceException(exception.getMessage());
        }
        try {
            if (this.needsConversion(schema)) {
                this.doConvert(schema);
            }
            SchemaHelper.setVersion(this._connection, "V0.7.2");
            this._connection.commit();
        }
        catch (SQLException exception) {
            SQLHelper.rollback((Connection)this._connection);
            throw new PersistenceException((Throwable)exception);
        }
    }

    private boolean needsConversion(Database schema) throws PersistenceException {
        boolean result = false;
        SchemaBrowser browser = this._tool.getSchemaBrowser();
        Table table = SchemaHelper.getTable(schema, DESTINATIONS_TABLE);
        Attribute column = SchemaHelper.getAttribute(table, ISQUEUE_COLUMN);
        Type expected = browser.getType(column);
        try {
            Table currentTable = browser.getTable(DESTINATIONS_TABLE);
            Attribute currentColumn = SchemaHelper.getAttribute(currentTable, ISQUEUE_COLUMN);
            Type currentType = browser.getType(currentColumn);
            result = currentType.getType() != expected.getType();
        }
        catch (InvalidTypeException exception) {
            _log.warn((Object)exception);
            result = true;
        }
        return result;
    }

    private void doConvert(Database schema) throws PersistenceException {
        Table table = SchemaHelper.getTable(schema, DESTINATIONS_TABLE);
        Table tmpTable = new Table();
        String tmpName = "openjms_tmp_destinations";
        tmpTable.setName(tmpName);
        tmpTable.setAttribute(table.getAttribute());
        this._tool.drop(tmpTable);
        this._tool.create(tmpTable);
        PreparedStatement select = null;
        ResultSet set = null;
        try {
            try {
                select = this._connection.prepareStatement("select * from destinations");
                set = select.executeQuery();
                while (set.next()) {
                    String name = set.getString(1);
                    boolean isQueue = set.getInt(2) > 0;
                    long id = set.getLong(3);
                    this.insert(tmpName, name, isQueue, id);
                }
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to convert destinations", (Throwable)exception);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            SQLHelper.close(set);
            SQLHelper.close((Statement)select);
            throw throwable;
        }
        SQLHelper.close((ResultSet)set);
        SQLHelper.close((Statement)select);
        this._tool.drop(table);
        this._tool.create(table);
        PreparedStatement insert = null;
        try {
            try {
                insert = this._connection.prepareStatement("insert into destinations select * from " + tmpName);
                insert.executeQuery();
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to copy converted destinations", (Throwable)exception);
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            SQLHelper.close(insert);
            throw throwable;
        }
        SQLHelper.close((Statement)insert);
        this._tool.drop(tmpTable);
    }

    private void insert(String table, String name, boolean isQueue, long id) throws SQLException {
        PreparedStatement insert = this._connection.prepareStatement("insert into " + table + " values (?, ?, ?)");
        insert.setString(1, name);
        insert.setBoolean(2, isQueue);
        insert.setLong(3, id);
        insert.executeUpdate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

