/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.RdbmsDatabaseConfiguration;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.persistence.SQLHelper;
import org.exolab.jms.tools.db.Attribute;
import org.exolab.jms.tools.db.Column;
import org.exolab.jms.tools.db.Database;
import org.exolab.jms.tools.db.Deprecated;
import org.exolab.jms.tools.db.Index;
import org.exolab.jms.tools.db.PrimaryKey;
import org.exolab.jms.tools.db.SchemaBrowser;
import org.exolab.jms.tools.db.Table;
import org.exolab.jms.tools.db.Type;

public class RDBMSTool {
    private Connection _connection = null;
    private SchemaBrowser _browser = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tools$db$RDBMSTool == null ? (class$org$exolab$jms$tools$db$RDBMSTool = RDBMSTool.class$("org.exolab.jms.tools.db.RDBMSTool")) : class$org$exolab$jms$tools$db$RDBMSTool));
    static /* synthetic */ Class class$org$exolab$jms$tools$db$RDBMSTool;

    public RDBMSTool(Connection connection) throws PersistenceException {
        this.init(connection);
    }

    public RDBMSTool(Configuration config) throws PersistenceException {
        RdbmsDatabaseConfiguration rdbms = config.getDatabaseConfiguration().getRdbmsDatabaseConfiguration();
        if (rdbms == null) {
            throw new PersistenceException("Configuration not configured to use an RDBMS");
        }
        Connection connection = null;
        try {
            Class.forName(rdbms.getDriver());
            connection = DriverManager.getConnection(rdbms.getUrl(), rdbms.getUser(), rdbms.getPassword());
        }
        catch (SQLException exception) {
            throw new PersistenceException((Throwable)exception);
        }
        catch (ClassNotFoundException exception) {
            throw new PersistenceException((Throwable)exception);
        }
        this.init(connection);
    }

    public boolean hasTables(Table[] tables) throws PersistenceException {
        boolean result = true;
        int i = 0;
        while (i < tables.length) {
            if (!this._browser.getTableExists(tables[i].getName())) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public void create(Database schema) throws PersistenceException {
        Table[] tables = schema.getTable();
        int i = 0;
        while (i < tables.length) {
            this.create(tables[i]);
            ++i;
        }
    }

    public void drop(Database schema) throws PersistenceException {
        Table[] tables = schema.getTable();
        int i = 0;
        while (i < tables.length) {
            this.drop(tables[i]);
            ++i;
        }
        Deprecated[] redundant = schema.getDeprecated();
        int i2 = 0;
        while (i2 < redundant.length) {
            this.dropTable(redundant[i2].getName());
            ++i2;
        }
    }

    public void delete(Database schema) throws PersistenceException {
        Table[] tables = schema.getTable();
        int i = 0;
        while (i < tables.length) {
            this.deleteTable(tables[i].getName());
            ++i;
        }
    }

    public void close() {
        SQLHelper.close((Connection)this._connection);
    }

    public void create(Table table) throws PersistenceException {
        String name = table.getName();
        if (this._browser.getTableExists(name)) {
            throw new PersistenceException("An object already exists in the database named " + name);
        }
        StringBuffer sql = new StringBuffer("create table ");
        sql.append(name);
        sql.append(" (");
        _log.debug((Object)("Creating table: " + name));
        Attribute[] attributes = table.getAttribute();
        int i = 0;
        while (i < attributes.length) {
            if (i > 0) {
                sql.append(", ");
            }
            Attribute attribute = attributes[i];
            sql.append(attribute.getName());
            sql.append(" ");
            sql.append(this.getSQLType(attribute));
            if (attribute.getNotNull()) {
                sql.append(" not null");
            }
            if (attribute.getPrimaryKey()) {
                sql.append(" primary key");
            }
            if (attribute.getUnique()) {
                sql.append(" unique");
            }
            ++i;
        }
        PrimaryKey key = table.getPrimaryKey();
        if (key != null) {
            sql.append(", primary key (");
            Column[] columns = key.getColumn();
            int i2 = 0;
            while (i2 < columns.length) {
                if (i2 > 0) {
                    sql.append(", ");
                }
                sql.append(columns[i2].getName());
                ++i2;
            }
            sql.append(")");
        }
        sql.append(")");
        _log.debug((Object)("SQL=" + sql));
        Statement statement = null;
        try {
            try {
                statement = this._connection.createStatement();
                statement.executeUpdate(sql.toString());
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to create table=" + name, (Throwable)exception);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            SQLHelper.close((Statement)statement);
            throw throwable;
        }
        SQLHelper.close((Statement)statement);
        this.createIndexes(table);
    }

    public void drop(Table table) throws PersistenceException {
        this.dropTable(table.getName());
    }

    public SchemaBrowser getSchemaBrowser() {
        return this._browser;
    }

    private void init(Connection connection) throws PersistenceException {
        this._connection = connection;
        try {
            this._connection.setAutoCommit(true);
        }
        catch (SQLException exception) {
            throw new PersistenceException("Failed to set auto-commit on", (Throwable)exception);
        }
        this._browser = new SchemaBrowser(this._connection);
    }

    private void createIndexes(Table table) throws PersistenceException {
        Index[] indexes = table.getIndex();
        int i = 0;
        while (i < indexes.length) {
            Object var11_9;
            Index index = indexes[i];
            StringBuffer sql = new StringBuffer("create ");
            if (index.getUnique()) {
                sql.append("unique ");
            }
            sql.append("index ");
            sql.append(index.getName());
            sql.append(" on ");
            sql.append(table.getName());
            sql.append("(");
            Column[] columns = index.getColumn();
            int j = 0;
            while (j < columns.length) {
                if (j > 0) {
                    sql.append(", ");
                }
                sql.append(columns[j].getName());
                ++j;
            }
            sql.append(")");
            _log.debug((Object)("SQL=" + sql));
            Statement statement = null;
            try {
                try {
                    statement = this._connection.createStatement();
                    statement.executeUpdate(sql.toString());
                }
                catch (SQLException exception) {
                    throw new PersistenceException("Failed to create index=" + index.getName() + " on table " + table.getName(), (Throwable)exception);
                }
                var11_9 = null;
            }
            catch (Throwable throwable) {
                var11_9 = null;
                SQLHelper.close((Statement)statement);
                throw throwable;
            }
            SQLHelper.close((Statement)statement);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dropTable(String name) throws PersistenceException {
        if (!this._browser.getTableExists(name)) return;
        String sql = "drop table " + name;
        _log.debug((Object)("SQL=" + sql));
        Statement statement = null;
        try {
            try {
                statement = this._connection.createStatement();
                statement.executeUpdate(sql);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to drop table=" + name, (Throwable)exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close((Statement)statement);
            throw throwable;
        }
        SQLHelper.close((Statement)statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteTable(String name) throws PersistenceException {
        if (!this._browser.getTableExists(name)) return;
        String sql = "delete from " + name;
        _log.debug((Object)("SQL=" + sql));
        Statement statement = null;
        try {
            try {
                statement = this._connection.createStatement();
                statement.execute(sql);
            }
            catch (SQLException exception) {
                throw new PersistenceException("Failed to delete from table=" + name, (Throwable)exception);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            SQLHelper.close((Statement)statement);
            throw throwable;
        }
        SQLHelper.close((Statement)statement);
    }

    private String getSQLType(Attribute attribute) throws PersistenceException {
        Type result = this._browser.getType(attribute);
        _log.debug((Object)("attribute=" + attribute.getName() + "->" + result));
        return result.getSQL();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

