/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.CreateTopicDialog;
import org.exolab.jms.tools.admin.OpenJMSConsumer;
import org.exolab.jms.tools.admin.OpenJMSObject;
import org.exolab.jms.tools.admin.QueryDialog;

public class OpenJMSTopic
extends OpenJMSObject {
    public OpenJMSTopic(String topic, JTree tree) {
        super(topic, tree);
    }

    protected void createCommands() {
        this._commands = new JPopupMenu();
        JMenuItem m = new JMenuItem("Add Consumer");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSTopic.addConsumer();
            }
        });
        this._commands.add(m);
        m = new JMenuItem("Delete Topic");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSTopic.deleteTopic();
            }
        });
        this._commands.add(m);
    }

    private static void editTopic() {
        OpenJMSTopic This = (OpenJMSTopic)OpenJMSObject.getInstanceSelected();
        System.out.println("editTopic");
    }

    public void update() {
        if (!this._isExplored) {
            Enumeration e = AbstractAdminConnection.instance().getDurableConsumers(this._name);
            if (e != null) {
                while (e.hasMoreElements()) {
                    String consumer = (String)e.nextElement();
                    this.add(new OpenJMSConsumer(consumer, OpenJMSObject._tree));
                }
                this.refresh();
            }
            this._isExplored = true;
        }
    }

    private static void addConsumer() {
        OpenJMSTopic This = (OpenJMSTopic)OpenJMSObject.getInstanceSelected();
        CreateTopicDialog.instance().displayCreateConsumer();
        if (CreateTopicDialog.instance().isConfirmed()) {
            boolean err = false;
            String errMessage = null;
            if (!This._isExplored) {
                This.update();
            }
            if (!AbstractAdminConnection.instance().durableConsumerExists(CreateTopicDialog.instance().getName())) {
                if (AbstractAdminConnection.instance().addDurableConsumer(This._name, CreateTopicDialog.instance().getName())) {
                    This.add(new OpenJMSConsumer(CreateTopicDialog.instance().getName(), OpenJMSObject._tree));
                    This.refresh();
                } else {
                    err = true;
                    errMessage = "Failed to update database";
                }
            } else {
                err = true;
                errMessage = "Consumer already exists";
            }
            if (err) {
                JOptionPane.showMessageDialog(OpenJMSObject._tree, errMessage, "Create Consumer Error", 0);
            }
        }
    }

    private static void deleteTopic() {
        OpenJMSTopic This = (OpenJMSTopic)OpenJMSObject.getInstanceSelected();
        QueryDialog.instance().display("Are you sure you want to delete \nselected Topic: " + This._name);
        if (QueryDialog.instance().isConfirmed()) {
            if (AbstractAdminConnection.instance().removeDestination(This._name)) {
                This.removeFromParent();
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(OpenJMSObject._tree, "Failed to destroy Topic", "Destroy Topic Error", 0);
            }
        }
    }
}

