/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exolab.jms.tools.admin.OpenJMSNode;

public abstract class OpenJMSObject
extends DefaultMutableTreeNode
implements OpenJMSNode {
    protected String _name;
    protected boolean _isLeaf;
    protected boolean _isExplored = false;
    protected JPopupMenu _commands = null;
    protected boolean _commandsCreated = false;
    protected static SimpleDateFormat _dateFormat;
    protected static JTree _tree;

    public OpenJMSObject(String destinationName, JTree tree) {
        this._name = destinationName;
        this._isLeaf = false;
        if (!this._commandsCreated) {
            _tree = tree;
            this.createCommands();
            this._commandsCreated = true;
            _dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            _dateFormat.setLenient(false);
        }
    }

    protected abstract void createCommands();

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    public void displayCommands(Rectangle loc) {
        double x = loc.getX();
        double y = loc.getY();
        this._commands.show(_tree, (int)x, (int)(y += loc.getHeight()));
    }

    public String toString() {
        return this._name;
    }

    protected void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)_tree.getModel();
        model.nodeStructureChanged(this);
    }

    protected static OpenJMSObject getInstanceSelected() {
        Object loc = _tree.getLastSelectedPathComponent();
        return (OpenJMSObject)loc;
    }

    public abstract void update();

    static {
        _tree = null;
    }
}

