/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tools.admin;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.exolab.jms.tools.admin.AbstractAdminConnection;
import org.exolab.jms.tools.admin.OpenJMSNode;
import org.exolab.jms.tools.admin.OpenJMSTopic;
import org.exolab.jms.tools.admin.QueryDialog;

public class OpenJMSConsumer
extends DefaultMutableTreeNode
implements OpenJMSNode {
    private String consumerName_;
    private static JTree tree_ = null;
    private static boolean commandsCreated_ = false;
    private static JPopupMenu commands_ = null;

    public OpenJMSConsumer(String consumerName, JTree tree) {
        this.consumerName_ = consumerName;
        if (!commandsCreated_) {
            tree_ = tree;
            this.createCommands();
            commandsCreated_ = true;
        }
    }

    protected void createCommands() {
        commands_ = new JPopupMenu();
        JMenuItem m = new JMenuItem("De-Activate Consumer");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSConsumer.unregisterConsumer();
            }
        });
        commands_.add(m);
        m = new JMenuItem("Delete Consumer");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OpenJMSConsumer.deleteConsumer();
            }
        });
        commands_.add(m);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public void update() {
    }

    public void displayCommands(Rectangle loc) {
        double x = loc.getX();
        double y = loc.getY();
        commands_.show(tree_, (int)x, (int)(y += loc.getHeight()));
    }

    public String toString() {
        return this.consumerName_;
    }

    private void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)tree_.getModel();
        model.nodeStructureChanged(this);
    }

    private static OpenJMSConsumer getInstanceSelected() {
        Object loc = tree_.getLastSelectedPathComponent();
        return (OpenJMSConsumer)loc;
    }

    private static void editConsumer() {
        OpenJMSConsumer This = OpenJMSConsumer.getInstanceSelected();
        System.out.println("editConsumer");
    }

    private static void deleteConsumer() {
        OpenJMSConsumer This = OpenJMSConsumer.getInstanceSelected();
        QueryDialog.instance().display("Are you sure you want to delete \nselected Consumer: " + This.consumerName_);
        if (QueryDialog.instance().isConfirmed()) {
            OpenJMSTopic topic = (OpenJMSTopic)This.parent;
            if (AbstractAdminConnection.instance().removeDurableConsumer(This.consumerName_)) {
                This.removeFromParent();
                This.refresh();
            } else {
                JOptionPane.showMessageDialog(tree_, "Failed to remove Consumer", "Remove Consumer Error", 0);
            }
        }
    }

    private static void unregisterConsumer() {
        OpenJMSConsumer This = OpenJMSConsumer.getInstanceSelected();
        QueryDialog.instance().display("Are you sure you want to De-Activate \nselected Consumer: " + This.consumerName_);
        if (QueryDialog.instance().isConfirmed()) {
            OpenJMSTopic topic = (OpenJMSTopic)This.parent;
            if (!AbstractAdminConnection.instance().unregisterConsumer(This.consumerName_)) {
                JOptionPane.showMessageDialog(tree_, "Consumer is not currently active", "De-Activate Consumer Error", 0);
            }
        }
    }
}

