/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.tranlog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.tranlog.DataTransactionLogEntry;
import org.exolab.jms.tranlog.ExternalXid;
import org.exolab.jms.tranlog.SerializationHelper;
import org.exolab.jms.tranlog.StateTransactionLogEntry;
import org.exolab.jms.tranlog.TransactionLogException;
import org.exolab.jms.tranlog.TransactionState;

public class TransactionLog {
    private String _name = null;
    private long _size = 0L;
    private transient DataOutputStream _dos = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$tranlog$TransactionLog == null ? (class$org$exolab$jms$tranlog$TransactionLog = TransactionLog.class$("org.exolab.jms.tranlog.TransactionLog")) : class$org$exolab$jms$tranlog$TransactionLog));
    static /* synthetic */ Class class$org$exolab$jms$tranlog$TransactionLog;

    public TransactionLog(String name, boolean create) throws TransactionLogException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Can't specify a null or empty name");
        }
        this._name = name;
        File file = new File(name);
        if (create) {
            if (file.exists()) {
                throw new TransactionLogException(name + " already exists");
            }
            try {
                new FileOutputStream(file).close();
            }
            catch (Exception exception) {
                throw new TransactionLogException("Failed to create the log file " + name + " b/c" + exception);
            }
        } else if (!file.exists()) {
            throw new TransactionLogException(name + " does not exists");
        }
        this._size = new File(name).length();
    }

    public String getName() {
        return this._name;
    }

    public synchronized void logTransactionState(ExternalXid txid, long expiry, String rid, TransactionState state) throws TransactionLogException {
        try {
            StateTransactionLogEntry entry = new StateTransactionLogEntry(txid, rid);
            entry.setState(state);
            entry.setExpiryTime(expiry);
            DataOutputStream dos = this.getOutputStream();
            byte[] blob = SerializationHelper.serialize(entry);
            dos.writeLong(blob.length);
            dos.write(blob, 0, blob.length);
            dos.flush();
            this._size += (long)blob.length;
        }
        catch (Exception exception) {
            throw new TransactionLogException("Error in logTransactionState " + exception.toString());
        }
    }

    public synchronized void logTransactionData(ExternalXid txid, long expiry, String rid, Object data) throws TransactionLogException {
        try {
            DataTransactionLogEntry entry = new DataTransactionLogEntry(txid, rid);
            entry.setData(data);
            entry.setExpiryTime(expiry);
            DataOutputStream dos = this.getOutputStream();
            byte[] blob = SerializationHelper.serialize(entry);
            dos.writeLong(blob.length);
            dos.write(blob, 0, blob.length);
            dos.flush();
            this._size += (long)blob.length;
        }
        catch (Exception exception) {
            throw new TransactionLogException("Error in logTransactionData " + exception.toString());
        }
    }

    public void close() throws TransactionLogException {
        try {
            if (this._dos != null) {
                this._dos.close();
            }
        }
        catch (IOException exception) {
            throw new TransactionLogException("Error in close " + exception.toString());
        }
    }

    public long size() {
        return this._size;
    }

    public synchronized HashMap recover() throws TransactionLogException {
        return this.getOpenTransactionList();
    }

    public synchronized boolean canGarbageCollect() {
        boolean result = false;
        try {
            HashMap records = this.getOpenTransactionList();
            if (records.size() == 0) {
                result = true;
            }
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
        return result;
    }

    public synchronized void destroy() throws TransactionLogException {
        try {
            this.close();
            if (!new File(this._name).delete()) {
                _log.error((Object)("Failed to destroy " + this._name));
            }
        }
        catch (Exception exception) {
            throw new TransactionLogException("Error in destroy " + exception.toString());
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TransactionLog && ((TransactionLog)obj)._name.equals(this._name)) {
            result = true;
        }
        return result;
    }

    private DataOutputStream getOutputStream() throws IOException, FileNotFoundException {
        if (this._dos == null) {
            this._dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._name, true)));
        }
        return this._dos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap getOpenTransactionList() throws TransactionLogException {
        HashMap<ExternalXid, LinkedList<DataTransactionLogEntry>> records = new HashMap<ExternalXid, LinkedList<DataTransactionLogEntry>>();
        try {
            if (this._dos != null) {
                this._dos.close();
                this._dos = null;
            }
        }
        catch (Exception exception) {
            throw new TransactionLogException("Error in recover " + exception.toString());
        }
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(this._name);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(fis));
                block14: while (dis.available() > 0) {
                    LinkedList<DataTransactionLogEntry> list;
                    byte[] blob = new byte[(int)dis.readLong()];
                    dis.readFully(blob);
                    Object object = SerializationHelper.deserialize(blob);
                    if (object instanceof StateTransactionLogEntry) {
                        StateTransactionLogEntry state = (StateTransactionLogEntry)object;
                        list = null;
                        switch (state.getState().getOrd()) {
                            case 1: {
                                if (records.containsKey(state.getExternalXid())) {
                                    _log.error((Object)"OPENED_ORD : Transaction log is inconsistent");
                                    continue block14;
                                }
                                list = new LinkedList<DataTransactionLogEntry>();
                                records.put(state.getExternalXid(), list);
                                list.add((DataTransactionLogEntry)((Object)state));
                                continue block14;
                            }
                            case 2: {
                                list = (LinkedList)records.get(state.getExternalXid());
                                if (list == null) {
                                    _log.error((Object)"PREPARED_ORD : Transaction log is inconsistent");
                                    continue block14;
                                }
                                list.add((DataTransactionLogEntry)((Object)state));
                                continue block14;
                            }
                            case 3: {
                                if (records.get(state.getExternalXid()) == null) {
                                    _log.error((Object)"CLOSED_ORD : Transaction log is inconsistent");
                                    continue block14;
                                }
                                records.remove(state.getExternalXid());
                                continue block14;
                            }
                        }
                        continue;
                    }
                    if (object instanceof DataTransactionLogEntry) {
                        DataTransactionLogEntry data = (DataTransactionLogEntry)object;
                        list = (LinkedList<DataTransactionLogEntry>)records.get(data.getExternalXid());
                        if (list == null) {
                            _log.error((Object)"DATA : Transaction log is inconsistent");
                            continue;
                        }
                        list.add(data);
                        continue;
                    }
                    System.err.println("There is no support for log entry records of type " + object.getClass().getName());
                }
            }
            catch (Exception exception) {
                throw new TransactionLogException("Error in recover " + exception.toString());
            }
            Object var9_10 = null;
            if (fis == null) return records;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw new TransactionLogException("Error in recover " + exception.toString());
            }
        }
        try {}
        catch (Exception exception) {
            throw new TransactionLogException("Error in recover " + exception.toString());
        }
        fis.close();
        return records;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

