/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.SocketConfigurationType;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.net.socket.SocketRequestInfo;
import org.exolab.jms.net.uri.URI;
import org.exolab.jms.net.util.Properties;
import org.exolab.jms.server.net.AbstractConnectorCfg;

abstract class SocketConnectorCfg
extends AbstractConnectorCfg {
    private SocketConfigurationType _config;

    public SocketConnectorCfg(SchemeType scheme, Configuration config, SocketConfigurationType socketConfig) {
        super(scheme, config);
        if (socketConfig == null) {
            throw new IllegalArgumentException("Argument 'socketConfig' is null");
        }
        this._config = socketConfig;
    }

    protected void populateAcceptProperties(Properties properties) {
        SocketRequestInfo info;
        URI uri = this.getURI(this.getExportURI());
        try {
            info = new SocketRequestInfo(uri);
        }
        catch (ResourceException exception) {
            throw new IllegalStateException(exception.getMessage());
        }
        this.populateRequestInfo(info);
        info.export(properties);
    }

    protected void populateRequestInfo(SocketRequestInfo info) {
        info.setBindAll(this._config.getBindAll());
    }

    protected SocketConfigurationType getSocketConfiguration() {
        return this._config;
    }
}

