/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.spice.jndikit.NamingProvider;
import org.exolab.jms.common.threads.ThreadPoolFactory;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.orb.ORBFactory;
import org.exolab.jms.net.registry.LocalRegistry;
import org.exolab.jms.server.AdminConnectionManager;
import org.exolab.jms.server.NameService;
import org.exolab.jms.server.ServerConnectionFactory;
import org.exolab.jms.server.ServerConnector;
import org.exolab.jms.server.ServerException;
import org.exolab.jms.server.net.ConnectionFactoryHelper;
import org.exolab.jms.server.net.ConnectorCfg;
import org.exolab.jms.server.net.ConnectorCfgFactory;
import org.exolab.jms.server.net.JmsAdminServerImpl;
import org.exolab.jms.server.net.RemoteNamingProvider;
import org.exolab.jms.server.net.RemoteServerConnectionFactory;

public class RemoteServerConnector
implements ServerConnector {
    private final Configuration _config;
    private final ConnectorCfg _connector;
    private final Authenticator _authenticator;
    private final ServerConnectionFactory _factory;
    private final AdminConnectionManager _manager;
    private final NameService _names;
    private final ThreadPoolFactory _threads;
    private final String _exportURI;
    private final String _connectURI;
    private ORB _orb;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$net$RemoteServerConnector == null ? (class$org$exolab$jms$server$net$RemoteServerConnector = RemoteServerConnector.class$("org.exolab.jms.server.net.RemoteServerConnector")) : class$org$exolab$jms$server$net$RemoteServerConnector));
    static /* synthetic */ Class class$org$exolab$jms$server$net$RemoteServerConnector;
    static /* synthetic */ Class class$org$exolab$jms$client$net$JmsServerStubImpl;

    public RemoteServerConnector(SchemeType scheme, Configuration config, Authenticator authenticator, ServerConnectionFactory factory, AdminConnectionManager manager, NameService names, ThreadPoolFactory threads) {
        if (scheme == null) {
            throw new IllegalArgumentException("Argument 'scheme' is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 'manager' is null");
        }
        if (names == null) {
            throw new IllegalArgumentException("Arguement 'names' is null");
        }
        if (threads == null) {
            throw new IllegalArgumentException("Arguement 'threads' is null");
        }
        this._connector = ConnectorCfgFactory.create(scheme, config);
        this._config = config;
        this._authenticator = authenticator;
        this._factory = factory;
        this._manager = manager;
        this._names = names;
        this._threads = threads;
        this._exportURI = this._connector.getExportURI();
        this._connectURI = this._connector.getConnectURI();
    }

    public void init() throws ServerException {
        try {
            Map properties = this._connector.getAcceptProperties();
            properties.put("org.exolab.jms.net.orb.threads.factory", this._threads);
            this._orb = ORBFactory.createORB((Authenticator)this._authenticator, (Map)properties);
            if (!this._connectURI.equals(this._exportURI)) {
                this._orb.addRoute(this._exportURI, this._connectURI);
            }
        }
        catch (RemoteException exception) {
            throw new ServerException("Failed to create ORB for URI:" + this._exportURI, exception);
        }
        try {
            LocalRegistry registry = this._orb.getRegistry();
            RemoteServerConnectionFactory server = new RemoteServerConnectionFactory(this._factory, this._orb, this._exportURI);
            registry.bind("server", server.getProxy());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Server accepting connections on " + this._exportURI));
            }
            if (this._config.getServerConfiguration().getEmbeddedJNDI()) {
                NamingProvider provider = this._names.getNamingProvider();
                RemoteNamingProvider jndi = new RemoteNamingProvider(provider, this._orb, this._connector.getJNDIExportURI());
                registry.bind("jndi", jndi.getProxy());
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("JNDI service accepting connections on " + this._connector.getJNDIExportURI()));
                }
            }
            JmsAdminServerImpl admin = new JmsAdminServerImpl(this._manager, this._orb, this._connector.getAdminExportURI());
            registry.bind("admin", admin.getProxy());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Admin service accepting connections on " + this._connector.getAdminExportURI()));
            }
            registry.setReadOnly(true);
        }
        catch (Exception exception) {
            throw new ServerException("Failed to initialise the server interface", exception);
        }
    }

    public void bindConnectionFactories(Context context) throws NamingException {
        Map properties = this._connector.getConnectProperties();
        Hashtable env = new Hashtable();
        env.putAll(properties);
        ConnectionFactoryHelper.bind(context, this._connector.getConnectionFactories(), class$org$exolab$jms$client$net$JmsServerStubImpl == null ? (class$org$exolab$jms$client$net$JmsServerStubImpl = RemoteServerConnector.class$("org.exolab.jms.client.net.JmsServerStubImpl")) : class$org$exolab$jms$client$net$JmsServerStubImpl, env);
    }

    public void close() throws ServerException {
        try {
            this._orb.shutdown();
        }
        catch (RemoteException exception) {
            throw new ServerException(exception.getMessage(), exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

