/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import java.rmi.RemoteException;
import javax.jms.JMSException;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.orb.UnicastObject;
import org.exolab.jms.server.ServerConnection;
import org.exolab.jms.server.ServerConnectionFactory;
import org.exolab.jms.server.net.RemoteServerConnection;

class RemoteServerConnectionFactory
extends UnicastObject
implements ServerConnectionFactory {
    private final ServerConnectionFactory _factory;

    public RemoteServerConnectionFactory(ServerConnectionFactory factory, ORB orb, String uri) throws RemoteException {
        super(orb, uri);
        if (factory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        this._factory = factory;
    }

    public ServerConnection createConnection(String clientID, String userName, String password) throws JMSException {
        ServerConnection connection = this._factory.createConnection(clientID, userName, password);
        RemoteServerConnection remote = null;
        try {
            remote = new RemoteServerConnection(connection, this.getORB());
        }
        catch (RemoteException exception) {
            throw new JMSException(exception.getMessage());
        }
        return (ServerConnection)remote.getProxy();
    }
}

