/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.net.connector.Caller;
import org.exolab.jms.net.connector.CallerListener;
import org.exolab.jms.net.orb.ORB;
import org.exolab.jms.net.orb.UnicastObject;
import org.exolab.jms.server.ServerConnection;
import org.exolab.jms.server.ServerSession;
import org.exolab.jms.server.net.RemoteServerSession;

public class RemoteServerConnection
extends UnicastObject
implements ServerConnection,
CallerListener {
    private ServerConnection _connection;
    private final String _uri;
    private List _sessions = Collections.synchronizedList(new ArrayList());
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$net$RemoteServerConnection == null ? (class$org$exolab$jms$server$net$RemoteServerConnection = RemoteServerConnection.class$("org.exolab.jms.server.net.RemoteServerConnection")) : class$org$exolab$jms$server$net$RemoteServerConnection));
    static /* synthetic */ Class class$org$exolab$jms$server$net$RemoteServerConnection;

    public RemoteServerConnection(ServerConnection connection, ORB orb) throws RemoteException {
        super(orb, null, true);
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        Caller caller = orb.getCaller();
        if (caller == null) {
            throw new ExportException("Can't determine remote caller");
        }
        this._uri = caller.getRemoteURI().toString();
        orb.addCallerListener(this._uri, (CallerListener)this);
        this._connection = connection;
    }

    public long getConnectionId() throws JMSException {
        return this._connection.getConnectionId();
    }

    public String getClientID() throws JMSException {
        return this._connection.getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        this._connection.setClientID(clientID);
    }

    public ServerSession createSession(int acknowledgeMode, boolean transacted) throws JMSException {
        ServerSession session = this._connection.createSession(acknowledgeMode, transacted);
        RemoteServerSession remote = null;
        try {
            remote = new RemoteServerSession(this.getORB(), this, session);
            this._sessions.add(remote);
        }
        catch (RemoteException exception) {
            throw new JMSException(exception.getMessage());
        }
        return (ServerSession)remote.getProxy();
    }

    public void close() throws JMSException {
        JMSException rethrow = null;
        RemoteServerSession[] sessions = this._sessions.toArray(new RemoteServerSession[0]);
        if (sessions.length != 0) {
            _log.debug((Object)"Cleaning up active sessions");
            int i = 0;
            while (i < sessions.length) {
                block10: {
                    try {
                        sessions[i].close();
                    }
                    catch (JMSException exception) {
                        rethrow = exception;
                        if (!_log.isDebugEnabled()) break block10;
                        _log.debug((Object)"Exception while cleaning up session", (Throwable)exception);
                    }
                }
                ++i;
            }
        }
        try {
            this._connection.close();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.getORB().removeCallerListener(this._uri, (CallerListener)this);
                this.unexportObject();
            }
            catch (RemoteException exception) {
                throw new JMSException(exception.getMessage());
            }
            throw throwable;
        }
        try {
            this.getORB().removeCallerListener(this._uri, (CallerListener)this);
            this.unexportObject();
        }
        catch (RemoteException exception) {
            throw new JMSException(exception.getMessage());
        }
        if (rethrow != null) {
            throw rethrow;
        }
    }

    public void disconnected(Caller caller) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Detected disconnection of caller=" + caller.getRemoteURI() + ". Cleaning up resources"));
        }
        try {
            this.close();
        }
        catch (JMSException exception) {
            _log.debug((Object)("Failed to clean up resources of caller=" + caller.getRemoteURI()), (Throwable)exception);
        }
    }

    public void closed(RemoteServerSession session) {
        this._sessions.remove(session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

