/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.net;

import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsConnectionFactory;
import org.exolab.jms.client.JmsXAConnectionFactory;
import org.exolab.jms.config.ConnectionFactories;
import org.exolab.jms.config.ConnectionFactory;
import org.exolab.jms.config.ConnectionFactoryType;
import org.exolab.jms.config.QueueConnectionFactory;
import org.exolab.jms.config.TopicConnectionFactory;
import org.exolab.jms.config.XAConnectionFactory;
import org.exolab.jms.config.XAQueueConnectionFactory;
import org.exolab.jms.config.XATopicConnectionFactory;

public class ConnectionFactoryHelper {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$net$ConnectionFactoryHelper == null ? (class$org$exolab$jms$server$net$ConnectionFactoryHelper = ConnectionFactoryHelper.class$("org.exolab.jms.server.net.ConnectionFactoryHelper")) : class$org$exolab$jms$server$net$ConnectionFactoryHelper));
    static /* synthetic */ Class class$org$exolab$jms$server$net$ConnectionFactoryHelper;
    static /* synthetic */ Class class$org$exolab$jms$client$JmsServerStubIfc;

    public static void bind(Context context, ConnectionFactories factories, Class implementation, Map properties) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException("Argument 'context' is null");
        }
        if (factories == null) {
            throw new IllegalArgumentException("Argument 'factories' is null");
        }
        if (implementation == null) {
            throw new IllegalArgumentException("Argument 'implementation' is null");
        }
        if (!(class$org$exolab$jms$client$JmsServerStubIfc == null ? (class$org$exolab$jms$client$JmsServerStubIfc = ConnectionFactoryHelper.class$("org.exolab.jms.client.JmsServerStubIfc")) : class$org$exolab$jms$client$JmsServerStubIfc).isAssignableFrom(implementation)) {
            throw new IllegalArgumentException("Class " + implementation.getName() + " does not implement " + (class$org$exolab$jms$client$JmsServerStubIfc == null ? (class$org$exolab$jms$client$JmsServerStubIfc = ConnectionFactoryHelper.class$("org.exolab.jms.client.JmsServerStubIfc")) : class$org$exolab$jms$client$JmsServerStubIfc).getName());
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument properties is null");
        }
        ConnectionFactory[] type = factories.getConnectionFactory();
        QueueConnectionFactory[] queue = factories.getQueueConnectionFactory();
        TopicConnectionFactory[] topic = factories.getTopicConnectionFactory();
        XAConnectionFactory[] xatype = factories.getXAConnectionFactory();
        XAQueueConnectionFactory[] xaqueue = factories.getXAQueueConnectionFactory();
        XATopicConnectionFactory[] xatopic = factories.getXATopicConnectionFactory();
        int i = 0;
        while (i < type.length) {
            ConnectionFactoryHelper.bind(context, type[i], implementation, properties);
            ++i;
        }
        int i2 = 0;
        while (i2 < queue.length) {
            ConnectionFactoryHelper.bind(context, queue[i2], implementation, properties);
            ++i2;
        }
        int i3 = 0;
        while (i3 < topic.length) {
            ConnectionFactoryHelper.bind(context, topic[i3], implementation, properties);
            ++i3;
        }
        int i4 = 0;
        while (i4 < xatype.length) {
            ConnectionFactoryHelper.bind(context, xatype[i4], implementation, properties);
            ++i4;
        }
        int i5 = 0;
        while (i5 < xaqueue.length) {
            ConnectionFactoryHelper.bind(context, xaqueue[i5], implementation, properties);
            ++i5;
        }
        int i6 = 0;
        while (i6 < xatopic.length) {
            ConnectionFactoryHelper.bind(context, xatopic[i6], implementation, properties);
            ++i6;
        }
    }

    private static void bind(Context context, ConnectionFactoryType factory, Class implementation, Map properties) throws NamingException {
        JmsConnectionFactory instance = null;
        if (factory instanceof ConnectionFactory || factory instanceof QueueConnectionFactory || factory instanceof TopicConnectionFactory) {
            instance = new JmsConnectionFactory(implementation.getName(), properties, null);
        } else if (factory instanceof javax.jms.XAConnectionFactory || factory instanceof XAQueueConnectionFactory || factory instanceof XATopicConnectionFactory) {
            instance = new JmsXAConnectionFactory(implementation.getName(), properties);
        } else {
            throw new IllegalArgumentException("Unknown connection factory type: " + factory.getClass().getName());
        }
        context.rebind(factory.getName(), (Object)instance);
        _log.debug((Object)("Bound connection factory " + factory.getName()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

