/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.Iterator;
import java.util.List;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DurableConsumerEndpoint;
import org.exolab.jms.messagemgr.Flag;
import org.exolab.jms.messagemgr.MessageManager;
import org.exolab.jms.messagemgr.ResourceManager;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.ServerConnectionImpl;
import org.exolab.jms.server.ServerSession;
import org.exolab.jms.server.SessionConsumer;

class ServerSessionImpl
implements ServerSession,
XAResource {
    private final ServerConnectionImpl _connection;
    private final MessageManager _messages;
    private final ConsumerManager _consumerMgr;
    private final ResourceManager _resources;
    private Xid _xid = null;
    private Flag _closed = new Flag(false);
    private final SessionConsumer _consumer;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$ServerSessionImpl == null ? (class$org$exolab$jms$server$ServerSessionImpl = ServerSessionImpl.class$("org.exolab.jms.server.ServerSessionImpl")) : class$org$exolab$jms$server$ServerSessionImpl));
    static /* synthetic */ Class class$org$exolab$jms$server$ServerSessionImpl;

    public ServerSessionImpl(ServerConnectionImpl connection, int ackMode, boolean transacted, MessageManager messageMgr, ConsumerManager consumerMgr, ResourceManager resourceMgr, DatabaseService database, Scheduler scheduler) {
        this._connection = connection;
        if (transacted) {
            ackMode = 0;
        }
        this._consumer = new SessionConsumer(ackMode, database, scheduler);
        this._messages = messageMgr;
        this._consumerMgr = consumerMgr;
        this._resources = resourceMgr;
    }

    public long getConnectionId() {
        return this._connection.getConnectionId();
    }

    public void acknowledgeMessage(long consumerId, String messageId) throws JMSException {
        this._consumer.acknowledge(consumerId, messageId);
    }

    public void send(MessageImpl message) throws JMSException {
        if (message == null) {
            throw new JMSException("Argument 'message' is null");
        }
        try {
            message.setConnectionId(this._connection.getConnectionId());
            if (this._xid != null) {
                this._resources.logPublishedMessage(this._xid, message);
            } else {
                this._messages.add(message);
            }
        }
        catch (JMSException exception) {
            _log.error((Object)"Failed to process message", (Throwable)exception);
            throw exception;
        }
        catch (OutOfMemoryError exception) {
            String msg = "Failed to process message due to out-of-memory error";
            _log.error((Object)msg, (Throwable)exception);
            throw new JMSException(msg);
        }
        catch (Exception exception) {
            String msg = "Failed to process message";
            _log.error((Object)msg, (Throwable)exception);
            throw new JMSException(msg);
        }
    }

    public void send(List messages) throws JMSException {
        if (messages == null) {
            throw new JMSException("Argument 'messages' is null");
        }
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            MessageImpl message = (MessageImpl)iterator.next();
            this.send(message);
        }
    }

    public MessageImpl receiveNoWait(long consumerId) throws JMSException {
        return this._consumer.receiveNoWait(consumerId);
    }

    public MessageImpl receive(long consumerId, long wait) throws JMSException {
        return this._consumer.receive(consumerId, wait);
    }

    public List browse(long consumerId, int count) throws JMSException {
        return this._consumer.browse(consumerId, count);
    }

    public long createConsumer(JmsDestination destination, String selector, boolean noLocal) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createConsumer(destination=" + destination + ", selector=" + selector + ", noLocal=" + noLocal + ") [session=" + this + "]"));
        }
        if (destination == null) {
            throw new InvalidDestinationException("Cannot create MessageConsumer for null destination");
        }
        ConsumerEndpoint consumer = this._consumerMgr.createConsumer(destination, this._connection.getConnectionId(), selector, noLocal);
        this._consumer.addConsumer(consumer);
        return consumer.getId();
    }

    public long createDurableConsumer(JmsTopic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createDurableConsumer(topic=" + topic + ", name=" + name + ", selector=" + selector + ", noLocal=" + noLocal + ") [session=" + this + "]"));
        }
        DurableConsumerEndpoint consumer = this._consumerMgr.createDurableConsumer(topic, name, this._connection.getClientID(), this._connection.getConnectionId(), noLocal, selector);
        this._consumer.addConsumer(consumer);
        return consumer.getId();
    }

    public long createBrowser(JmsQueue queue, String selector) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("createBrowser(queue=" + queue + ", selector=" + selector + ") [session=" + this + "]"));
        }
        if (queue == null) {
            throw new JMSException("Cannot create QueueBrowser for null queue");
        }
        ConsumerEndpoint consumer = this._consumerMgr.createQueueBrowser(queue, selector);
        this._consumer.addConsumer(consumer);
        return consumer.getId();
    }

    public void closeConsumer(long consumerId) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("removeConsumer(consumerId=" + consumerId + ") [session=" + this + "]"));
        }
        ConsumerEndpoint consumer = this._consumer.removeConsumer(consumerId);
        this._consumerMgr.closeConsumer(consumer);
    }

    public void unsubscribe(String name) throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("unsubscribe(name=" + name + ") [session=" + this + "]"));
        }
        this._consumerMgr.unsubscribe(name, this._connection.getClientID());
    }

    public void start() throws JMSException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("start() [session=" + this + "]"));
        }
        this._consumer.start();
    }

    public void stop() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("stop() [session=" + this + "]"));
        }
        this._consumer.stop();
    }

    public void setMessageListener(JmsMessageListener listener) {
        this._consumer.setMessageListener(listener);
    }

    public void setAsynchronous(long consumerId, boolean enable) throws JMSException {
        this._consumer.setAsynchronous(consumerId, enable);
    }

    public void close() throws JMSException {
        boolean closed;
        Flag flag = this._closed;
        synchronized (flag) {
            closed = this._closed.get();
        }
        if (!closed) {
            this._closed.set(true);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("close() [session=" + this + "]"));
            }
            this._consumer.stop();
            ConsumerEndpoint[] consumers = this._consumer.getConsumers();
            int i = 0;
            while (i < consumers.length) {
                ConsumerEndpoint consumer = consumers[i];
                this._consumer.removeConsumer(consumer.getId());
                this._consumerMgr.closeConsumer(consumer);
                ++i;
            }
            this._consumer.close();
            this._connection.closed(this);
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("close() [session=" + this + "]: session already closed"));
        }
    }

    public void recover() throws JMSException {
        this._consumer.recover();
    }

    public void commit() throws JMSException {
        this._consumer.commit();
    }

    public void rollback() throws JMSException {
        this._consumer.rollback();
    }

    public void start(Xid xid, int flags) throws XAException {
        this._resources.start(xid, flags);
        this._xid = xid;
    }

    public int prepare(Xid xid) throws XAException {
        return this._resources.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this._resources.commit(xid, onePhase);
            Object var4_3 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this._resources.end(xid, flags);
            Object var4_3 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this._resources.forget(xid);
            Object var3_2 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        return this._resources.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this._resources.rollback(xid);
            Object var3_2 = null;
            this._xid = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._xid = null;
            throw throwable;
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this._resources.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._resources.setTransactionTimeout(seconds);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        boolean result = xares instanceof ServerSessionImpl;
        if (result) {
            ServerSessionImpl other = (ServerSessionImpl)xares;
            result = other.getResourceManagerId() == this.getResourceManagerId();
        }
        return result;
    }

    public Xid getXid() {
        return this._xid;
    }

    public String getResourceManagerId() throws XAException {
        return this._resources.getResourceManagerId();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

