/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.HashMap;
import java.util.HashSet;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.security.BasicPrincipal;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.MessageManager;
import org.exolab.jms.messagemgr.ResourceManager;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.ServerConnection;
import org.exolab.jms.server.ServerConnectionImpl;
import org.exolab.jms.server.ServerConnectionManager;

public class ServerConnectionManagerImpl
implements ServerConnectionManager {
    private final Authenticator _authenticator;
    private final MessageManager _messages;
    private ConsumerManager _consumers;
    private ResourceManager _resources;
    private final DatabaseService _database;
    private final Scheduler _scheduler;
    private HashMap _connections = new HashMap();
    private HashSet _clientIDs = new HashSet();
    private long _seed = 0L;
    private final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$ServerConnectionManagerImpl == null ? (class$org$exolab$jms$server$ServerConnectionManagerImpl = ServerConnectionManagerImpl.class$("org.exolab.jms.server.ServerConnectionManagerImpl")) : class$org$exolab$jms$server$ServerConnectionManagerImpl));
    static /* synthetic */ Class class$org$exolab$jms$server$ServerConnectionManagerImpl;

    public ServerConnectionManagerImpl(Authenticator authenticator, MessageManager messages, DatabaseService database, Scheduler scheduler) {
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        if (messages == null) {
            throw new IllegalArgumentException("Argument 'messages' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        if (scheduler == null) {
            throw new IllegalArgumentException("Argument 'scheduler' is null");
        }
        this._authenticator = authenticator;
        this._messages = messages;
        this._database = database;
        this._scheduler = scheduler;
    }

    public void setConsumerManager(ConsumerManager consumers) {
        this._consumers = consumers;
    }

    public void setResourceManager(ResourceManager resources) {
        this._resources = resources;
    }

    public ServerConnection createConnection(String clientID, String userName, String password) throws JMSException {
        BasicPrincipal principal = null;
        if (userName != null) {
            principal = new BasicPrincipal(userName, password);
        }
        try {
            if (!this._authenticator.authenticate(principal)) {
                throw new JMSSecurityException("Failed to authenticate user: " + userName);
            }
        }
        catch (ResourceException exception) {
            this._log.error((Object)exception, (Throwable)exception);
            throw new JMSSecurityException("Failed to authenticate user " + userName);
        }
        ServerConnectionImpl result = null;
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            this.addClientID(clientID);
            long connectionId = ++this._seed;
            result = new ServerConnectionImpl(this, connectionId, clientID, this._messages, this._consumers, this._resources, this._database, this._scheduler);
            this._connections.put(new Long(connectionId), result);
        }
        return result;
    }

    public ServerConnectionImpl getConnection(long connectionId) {
        ServerConnectionImpl result = null;
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            Long key = new Long(connectionId);
            result = (ServerConnectionImpl)this._connections.get(key);
        }
        return result;
    }

    public void closed(ServerConnectionImpl connection) {
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            Long key = new Long(connection.getConnectionId());
            this._connections.remove(key);
            this._clientIDs.remove(connection.getClientID());
        }
    }

    public void addClientID(String clientID) throws InvalidClientIDException {
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            if (clientID != null && !this._clientIDs.add(clientID)) {
                throw new InvalidClientIDException("Duplicate clientID: " + clientID);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

