/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.util.HashSet;
import java.util.Iterator;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.MessageManager;
import org.exolab.jms.messagemgr.ResourceManager;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.scheduler.Scheduler;
import org.exolab.jms.server.ServerConnection;
import org.exolab.jms.server.ServerConnectionManagerImpl;
import org.exolab.jms.server.ServerSession;
import org.exolab.jms.server.ServerSessionImpl;

public class ServerConnectionImpl
implements ServerConnection {
    private final ServerConnectionManagerImpl _manager;
    private final long _connectionId;
    private String _clientId;
    private HashSet _sessions = new HashSet();
    private boolean _stopped = true;
    private final MessageManager _messages;
    private final ConsumerManager _consumers;
    private final ResourceManager _resources;
    private final DatabaseService _database;
    private final Scheduler _scheduler;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$ServerConnectionImpl == null ? (class$org$exolab$jms$server$ServerConnectionImpl = ServerConnectionImpl.class$("org.exolab.jms.server.ServerConnectionImpl")) : class$org$exolab$jms$server$ServerConnectionImpl));
    static /* synthetic */ Class class$org$exolab$jms$server$ServerConnectionImpl;

    protected ServerConnectionImpl(ServerConnectionManagerImpl manager, long connectionId, String clientId, MessageManager messages, ConsumerManager consumers, ResourceManager resources, DatabaseService database, Scheduler scheduler) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 'manager' is null");
        }
        if (messages == null) {
            throw new IllegalArgumentException("Argument 'messages' is null");
        }
        if (consumers == null) {
            throw new IllegalArgumentException("Argument 'consumers' is null");
        }
        if (resources == null) {
            throw new IllegalArgumentException("Argument 'resources' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        if (scheduler == null) {
            throw new IllegalArgumentException("Argument 'scheduler' is null");
        }
        this._manager = manager;
        this._connectionId = connectionId;
        this._clientId = clientId;
        this._messages = messages;
        this._consumers = consumers;
        this._resources = resources;
        this._database = database;
        this._scheduler = scheduler;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public String getClientID() {
        return this._clientId;
    }

    public void setClientID(String clientID) throws JMSException {
        if (clientID == null) {
            throw new InvalidClientIDException("Invalid clientID: " + clientID);
        }
        this._manager.addClientID(clientID);
        this._clientId = clientID;
    }

    public synchronized ServerSession createSession(int acknowledgeMode, boolean transacted) throws JMSException {
        ServerSessionImpl session = new ServerSessionImpl(this, acknowledgeMode, transacted, this._messages, this._consumers, this._resources, this._database, this._scheduler);
        this._sessions.add(session);
        if (!this._stopped) {
            session.start();
        }
        return session;
    }

    public synchronized void close() {
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            ServerSessionImpl session = (ServerSessionImpl)iterator.next();
            try {
                session.close();
            }
            catch (JMSException exception) {
                _log.debug((Object)"Failed to close session", (Throwable)exception);
            }
        }
        this._sessions.clear();
        this._manager.closed(this);
    }

    public synchronized void closed(ServerSessionImpl session) {
        this._sessions.remove(session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

