/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.common.security.BasicPrincipal;
import org.exolab.jms.net.connector.Authenticator;
import org.exolab.jms.net.connector.ResourceException;
import org.exolab.jms.server.AdminConnection;
import org.exolab.jms.server.AdminConnectionFactory;

public class AdminConnectionManager {
    private final Authenticator _authenticator;
    private final AdminConnectionFactory _factory;
    private final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$AdminConnectionManager == null ? (class$org$exolab$jms$server$AdminConnectionManager = AdminConnectionManager.class$("org.exolab.jms.server.AdminConnectionManager")) : class$org$exolab$jms$server$AdminConnectionManager));
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnectionManager;

    public AdminConnectionManager(Authenticator authenticator, AdminConnectionFactory factory) {
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        this._authenticator = authenticator;
        this._factory = factory;
    }

    public AdminConnection createConnection(String username, String password) throws JMSSecurityException, JMSException {
        BasicPrincipal principal = null;
        if (username != null) {
            principal = new BasicPrincipal(username, password);
        }
        try {
            if (!this._authenticator.authenticate(principal)) {
                throw new JMSSecurityException("Failed to authenticate user " + username);
            }
        }
        catch (ResourceException exception) {
            this._log.error((Object)exception, (Throwable)exception);
            throw new JMSSecurityException("Failed to authenticate user " + username);
        }
        return this._factory.create();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

