/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.authentication.AuthenticationMgr;
import org.exolab.jms.authentication.User;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.messagemgr.ConsumerEndpoint;
import org.exolab.jms.messagemgr.ConsumerManager;
import org.exolab.jms.messagemgr.DestinationCache;
import org.exolab.jms.messagemgr.DestinationManager;
import org.exolab.jms.messagemgr.DurableConsumerEndpoint;
import org.exolab.jms.persistence.DatabaseService;
import org.exolab.jms.persistence.PersistenceException;
import org.exolab.jms.service.ServiceException;
import org.exolab.jms.service.Services;

public class AdminConnection {
    private final Configuration _config;
    private final AuthenticationMgr _authenticator;
    private final DestinationManager _destinations;
    private final ConsumerManager _consumers;
    private final DatabaseService _database;
    private final Services _services;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$AdminConnection == null ? (class$org$exolab$jms$server$AdminConnection = AdminConnection.class$("org.exolab.jms.server.AdminConnection")) : class$org$exolab$jms$server$AdminConnection));
    static /* synthetic */ Class class$org$exolab$jms$server$AdminConnection;

    protected AdminConnection(Configuration config, AuthenticationMgr authenticator, DestinationManager destinations, ConsumerManager consumers, DatabaseService database, Services services) {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("Argument 'authenticator' is null");
        }
        if (destinations == null) {
            throw new IllegalArgumentException("Argument 'destinations' is null");
        }
        if (consumers == null) {
            throw new IllegalArgumentException("Argument 'consumers' is null");
        }
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' is null");
        }
        if (services == null) {
            throw new IllegalArgumentException("Argument 'services' is null");
        }
        this._config = config;
        this._authenticator = authenticator;
        this._destinations = destinations;
        this._consumers = consumers;
        this._database = database;
        this._services = services;
    }

    public void close() {
    }

    public int getDurableConsumerMessageCount(String topic, String name) {
        int count = -1;
        try {
            try {
                JmsDestination dest = this._destinations.getDestination(topic);
                ConsumerEndpoint endpoint = null;
                if (dest != null && (name != null || name.length() > 0)) {
                    endpoint = this._consumers.getConsumerEndpoint(name);
                    if (endpoint != null && endpoint.getDestination().equals(dest)) {
                        count = endpoint.getMessageCount();
                    } else if (dest.getPersistent()) {
                        try {
                            this._database.begin();
                            Connection connection = this._database.getConnection();
                            count = this._database.getAdapter().getDurableConsumerMessageCount(connection, topic, name);
                            this._database.commit();
                        }
                        catch (PersistenceException exception) {
                            _log.error((Object)exception, (Throwable)exception);
                            try {
                                this._database.rollback();
                            }
                            catch (PersistenceException error) {
                            }
                        }
                    }
                }
                Object var9_10 = null;
            }
            catch (Exception exception) {
                _log.error((Object)("Failed to get message count for topic=" + topic), (Throwable)exception);
                Object var9_11 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            throw throwable;
        }
        return count;
    }

    public int getQueueMessageCount(String queue) {
        int count = -1;
        try {
            JmsDestination dest = this._destinations.getDestination(queue);
            DestinationCache cache = null;
            if (dest != null) {
                this._database.begin();
                cache = this._destinations.getDestinationCache(dest);
                count = cache.getMessageCount();
                this._database.commit();
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Failed to get message count for queue=" + queue), (Throwable)exception);
            this.rollback();
        }
        return count;
    }

    public boolean addDurableConsumer(String topic, String name) {
        boolean result = false;
        try {
            JmsTopic t = new JmsTopic(topic);
            t.setPersistent(true);
            this._consumers.subscribe(t, name, null);
            result = true;
        }
        catch (JMSException exception) {
            _log.error((Object)("Failed to add durable consumer=" + name + " for topic=" + topic), (Throwable)exception);
        }
        return result;
    }

    public boolean removeDurableConsumer(String name) {
        boolean result = false;
        try {
            this._consumers.unsubscribe(name, null);
            result = true;
        }
        catch (JMSException exception) {
            _log.debug((Object)("Failed to remove durable consumer=" + name), (Throwable)exception);
        }
        return result;
    }

    public boolean durableConsumerExists(String name) {
        return this._consumers.getConsumerEndpoint(name) != null;
    }

    public Vector getDurableConsumers(String topic) {
        Enumeration iter = null;
        Vector result = new Vector();
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            iter = this._database.getAdapter().getDurableConsumers(connection, topic);
            while (iter.hasMoreElements()) {
                result.addElement(iter.nextElement());
            }
            this._database.commit();
        }
        catch (Exception exception) {
            _log.error((Object)("Failed on get durable consumers for topic=" + topic), (Throwable)exception);
            this.rollback();
        }
        return result;
    }

    public boolean unregisterConsumer(String name) {
        boolean success = false;
        ConsumerEndpoint endpoint = this._consumers.getConsumerEndpoint(name);
        if (endpoint != null) {
            this._consumers.closeConsumer(endpoint);
        }
        success = true;
        return success;
    }

    public boolean isConnected(String name) {
        boolean result = false;
        ConsumerEndpoint endpoint = this._consumers.getConsumerEndpoint(name);
        if (endpoint != null && endpoint instanceof DurableConsumerEndpoint) {
            result = ((DurableConsumerEndpoint)endpoint).isActive();
        }
        return result;
    }

    public Vector getAllDestinations() {
        Enumeration iter = null;
        Vector result = new Vector();
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            iter = this._database.getAdapter().getAllDestinations(connection);
            while (iter.hasMoreElements()) {
                result.addElement(iter.nextElement());
            }
            this._database.commit();
        }
        catch (Exception exception) {
            _log.error((Object)"Failed to get all destinations", (Throwable)exception);
            this.rollback();
        }
        return result;
    }

    public boolean addDestination(String name, Boolean queue) {
        boolean success = false;
        JmsDestination destination = queue != false ? new JmsQueue(name) : new JmsTopic(name);
        destination.setPersistent(true);
        try {
            if (this._destinations.getDestination(name) == null) {
                this._destinations.createDestination(destination);
                success = true;
            }
        }
        catch (JMSException exception) {
            _log.error((Object)("Failed to add destination=" + name), (Throwable)exception);
        }
        return success;
    }

    public boolean removeDestination(String name) {
        boolean success = false;
        JmsDestination dest = this._destinations.getDestination(name);
        if (dest != null) {
            try {
                this._destinations.removeDestination(dest);
                success = true;
            }
            catch (JMSException exception) {
                _log.error((Object)("Failed to remove destination=" + name), (Throwable)exception);
            }
        }
        return success;
    }

    public boolean destinationExists(String name) {
        JmsDestination dest = this._destinations.getDestination(name);
        return dest != null;
    }

    public void stopServer() {
        boolean isEmbedded = false;
        Connector[] connectors = this._config.getConnectors().getConnector();
        int i = 0;
        while (i < connectors.length) {
            if (connectors[i].getScheme().equals(SchemeType.EMBEDDED)) {
                isEmbedded = true;
                break;
            }
            ++i;
        }
        final boolean exit = !isEmbedded;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                _log.info((Object)"Stopping all services");
                try {
                    AdminConnection.this._services.stop();
                }
                catch (ServiceException exception) {
                    _log.error((Object)exception, (Throwable)exception);
                }
                if (exit) {
                    _log.info((Object)"Server shutdown scheduled for 5 secs");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public int purgeMessages() {
        return this._database.getAdapter().purgeMessages();
    }

    public boolean addUser(String username, String password) {
        return this._authenticator.addUser(new User(username, password));
    }

    public boolean changePassword(String username, String password) {
        return this._authenticator.updateUser(new User(username, password));
    }

    public boolean removeUser(String username) {
        return this._authenticator.removeUser(new User(username, null));
    }

    public Vector getAllUsers() {
        Enumeration iter = null;
        Vector result = new Vector();
        try {
            this._database.begin();
            Connection connection = this._database.getConnection();
            iter = this._database.getAdapter().getAllUsers(connection);
            while (iter.hasMoreElements()) {
                result.addElement(iter.nextElement());
            }
            this._database.commit();
        }
        catch (Exception exception) {
            _log.error((Object)"Failed on get all users", (Throwable)exception);
            this.rollback();
        }
        return result;
    }

    private void rollback() {
        try {
            this._database.rollback();
        }
        catch (PersistenceException exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

