/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector.parser;

import org.exolab.jms.selector.Type;
import org.exolab.jms.selector.TypeMismatchException;
import org.exolab.jms.selector.parser.SelectorAST;

final class TypeChecker {
    private TypeChecker() {
    }

    public static void check(SelectorAST node, Type expected) throws TypeMismatchException {
        Type type = node.getReturnType();
        if (type != expected && type != Type.UNDEFINED) {
            String msg = "expecting a " + expected + " expression, found a " + type;
            throw new TypeMismatchException(node.getContext(), msg);
        }
    }

    public static void check(String operator, SelectorAST node, Type expected) throws TypeMismatchException {
        Type type = node.getReturnType();
        if (type != expected && type != Type.UNDEFINED) {
            String msg = "expecting a " + expected + " expression for operator " + operator + ", found a " + type;
            throw new TypeMismatchException(node.getContext(), msg);
        }
    }

    public static void check(String operator, SelectorAST left, SelectorAST right, Type expected) throws TypeMismatchException {
        TypeChecker.check(operator, left, expected);
        TypeChecker.check(operator, right, expected);
    }

    public static void checkComparison(String operator, SelectorAST left, SelectorAST right) throws TypeMismatchException {
        Type lhs = left.getReturnType();
        Type rhs = right.getReturnType();
        if (lhs != Type.UNDEFINED && rhs != Type.UNDEFINED) {
            if (lhs == Type.STRING && rhs == Type.STRING) {
                TypeChecker.checkStringComparison(operator, left, right);
            } else if (lhs == Type.STRING && rhs != Type.STRING || lhs == Type.BOOLEAN && rhs != Type.BOOLEAN || lhs == Type.NUMERIC && rhs != Type.NUMERIC) {
                String msg = "expecting a " + lhs + " expression for operator " + operator + ", found a " + rhs;
                throw new TypeMismatchException(right.getContext(), msg);
            }
        }
    }

    public static void checkStringComparison(String operator, SelectorAST left, SelectorAST right) throws TypeMismatchException {
        if (left.getType() == 20 && right.getType() == 26) {
            TypeChecker.checkIdentifierComparison(left, right);
        } else if (left.getType() == 26 && right.getType() == 20) {
            TypeChecker.checkIdentifierComparison(right, left);
        }
    }

    public static void checkIdentifierComparison(SelectorAST identifier, SelectorAST literal) throws TypeMismatchException {
        String value;
        if (identifier.getText().equals("JMSDeliveryMode") && !(value = literal.getText()).equals("PERSISTENT") && !value.equals("NON_PERSISTENT")) {
            String msg = "Cannot compare JMSDeliveryMode with '" + value + "'";
            throw new TypeMismatchException(identifier.getContext(), msg);
        }
    }
}

