/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.selector.parser;

import antlr.MismatchedTokenException;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TreeParser;
import antlr.collections.AST;
import java.util.HashSet;
import org.exolab.jms.selector.Context;
import org.exolab.jms.selector.Expression;
import org.exolab.jms.selector.ExpressionFactory;
import org.exolab.jms.selector.SelectorException;
import org.exolab.jms.selector.Type;
import org.exolab.jms.selector.parser.PatternValidator;
import org.exolab.jms.selector.parser.SelectorAST;
import org.exolab.jms.selector.parser.SelectorTreeParserTokenTypes;
import org.exolab.jms.selector.parser.TypeChecker;

public class SelectorTreeParser
extends TreeParser
implements SelectorTreeParserTokenTypes {
    private ExpressionFactory _factory;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "UNARY_MINUS", "\"or\"", "\"and\"", "\"not\"", "=", "<>", "<", ">", "<=", ">=", "+", "-", "*", "/", "(", ")", "an identifier", "\"is\"", "\"null\"", "\"between\"", "\"in\"", "\"like\"", "a string literal", "\"escape\"", ",", "an integer", "NUM_FLOAT", "\"false\"", "\"true\"", "WS", "HEX_DIGIT", "EXPONENT", "FLOAT_SUFFIX", "IDENT_START", "IDENT_NON_START", "IDENT_PART"};

    public void initialise(ExpressionFactory factory) {
        this._factory = factory;
    }

    private void rethrow(String msg, AST node, Token token) throws SelectorException {
        if (node != null) {
            throw new SelectorException(((SelectorAST)node).getContext(), msg);
        }
        Context context = new Context(token.getLine(), token.getColumn());
        throw new SelectorException(context, msg);
    }

    public SelectorTreeParser() {
        this.tokenNames = _tokenNames;
    }

    public final Expression selector(AST _t) throws RecognitionException {
        SelectorAST selector_AST_in = (SelectorAST)_t;
        SelectorAST p = null;
        Expression expr = null;
        try {
            p = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
            expr = this.primaryExpression(_t);
            _t = this._retTree;
            TypeChecker.check(p, Type.BOOLEAN);
        }
        catch (NoViableAltException error) {
            this.rethrow(error.getMessage(), error.node, error.token);
        }
        catch (MismatchedTokenException error) {
            this.rethrow(error.getMessage(), error.node, error.token);
        }
        this._retTree = _t;
        return expr;
    }

    public final Expression primaryExpression(AST _t) throws RecognitionException {
        SelectorAST primaryExpression_AST_in = (SelectorAST)_t;
        SelectorAST p = null;
        SelectorAST orl = null;
        SelectorAST orr = null;
        SelectorAST andl = null;
        SelectorAST andr = null;
        SelectorAST eql = null;
        SelectorAST eqr = null;
        SelectorAST nel = null;
        SelectorAST ner = null;
        SelectorAST ltl = null;
        SelectorAST ltr = null;
        SelectorAST gtl = null;
        SelectorAST gtr = null;
        SelectorAST lel = null;
        SelectorAST ler = null;
        SelectorAST gel = null;
        SelectorAST ger = null;
        Expression expr = null;
        SelectorAST ast = primaryExpression_AST_in;
        Object left = null;
        Object right = null;
        Expression lhs = null;
        Expression rhs = null;
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 7: {
                AST __t102 = _t;
                SelectorAST tmp1_AST_in = (SelectorAST)_t;
                this.match(_t, 7);
                _t = _t.getFirstChild();
                p = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                expr = this.primaryExpression(_t);
                _t = this._retTree;
                _t = __t102;
                _t = _t.getNextSibling();
                TypeChecker.check(ast.getText(), p, Type.BOOLEAN);
                expr = this._factory.unaryOperator(ast.getType(), expr);
                break;
            }
            case 5: 
            case 6: {
                if (_t == null) {
                    _t = TreeParser.ASTNULL;
                }
                switch (_t.getType()) {
                    case 5: {
                        AST __t104 = _t;
                        SelectorAST tmp2_AST_in = (SelectorAST)_t;
                        this.match(_t, 5);
                        _t = _t.getFirstChild();
                        orl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.primaryExpression(_t);
                        _t = this._retTree;
                        orr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.primaryExpression(_t);
                        _t = this._retTree;
                        _t = __t104;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), orl, orr, Type.BOOLEAN);
                        break;
                    }
                    case 6: {
                        AST __t105 = _t;
                        SelectorAST tmp3_AST_in = (SelectorAST)_t;
                        this.match(_t, 6);
                        _t = _t.getFirstChild();
                        andl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.primaryExpression(_t);
                        _t = this._retTree;
                        andr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.primaryExpression(_t);
                        _t = this._retTree;
                        _t = __t105;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), andl, andr, Type.BOOLEAN);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                expr = this._factory.binaryOperator(ast.getType(), lhs, rhs);
                break;
            }
            case 8: 
            case 9: {
                if (_t == null) {
                    _t = TreeParser.ASTNULL;
                }
                switch (_t.getType()) {
                    case 8: {
                        AST __t107 = _t;
                        SelectorAST tmp4_AST_in = (SelectorAST)_t;
                        this.match(_t, 8);
                        _t = _t.getFirstChild();
                        eql = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        eqr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t107;
                        _t = _t.getNextSibling();
                        TypeChecker.checkComparison(ast.getText(), eql, eqr);
                        break;
                    }
                    case 9: {
                        AST __t108 = _t;
                        SelectorAST tmp5_AST_in = (SelectorAST)_t;
                        this.match(_t, 9);
                        _t = _t.getFirstChild();
                        nel = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        ner = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t108;
                        _t = _t.getNextSibling();
                        TypeChecker.checkComparison(ast.getText(), nel, ner);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                expr = this._factory.binaryOperator(ast.getType(), lhs, rhs);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                if (_t == null) {
                    _t = TreeParser.ASTNULL;
                }
                switch (_t.getType()) {
                    case 10: {
                        AST __t110 = _t;
                        SelectorAST tmp6_AST_in = (SelectorAST)_t;
                        this.match(_t, 10);
                        _t = _t.getFirstChild();
                        ltl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        ltr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t110;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), ltl, ltr, Type.NUMERIC);
                        break;
                    }
                    case 11: {
                        AST __t111 = _t;
                        SelectorAST tmp7_AST_in = (SelectorAST)_t;
                        this.match(_t, 11);
                        _t = _t.getFirstChild();
                        gtl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        gtr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t111;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), gtl, gtr, Type.NUMERIC);
                        break;
                    }
                    case 12: {
                        AST __t112 = _t;
                        SelectorAST tmp8_AST_in = (SelectorAST)_t;
                        this.match(_t, 12);
                        _t = _t.getFirstChild();
                        lel = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        ler = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t112;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), lel, ler, Type.NUMERIC);
                        break;
                    }
                    case 13: {
                        AST __t113 = _t;
                        SelectorAST tmp9_AST_in = (SelectorAST)_t;
                        this.match(_t, 13);
                        _t = _t.getFirstChild();
                        gel = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        ger = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t113;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), gel, ger, Type.NUMERIC);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                expr = this._factory.binaryOperator(ast.getType(), lhs, rhs);
                break;
            }
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                expr = this.expression(_t);
                _t = this._retTree;
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                expr = this.booleanExpression(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return expr;
    }

    public final Expression expression(AST _t) throws RecognitionException {
        SelectorAST expression_AST_in = (SelectorAST)_t;
        SelectorAST plusl = null;
        SelectorAST plusr = null;
        SelectorAST minusl = null;
        SelectorAST minusr = null;
        SelectorAST multl = null;
        SelectorAST multr = null;
        SelectorAST divl = null;
        SelectorAST divr = null;
        Expression expr = null;
        SelectorAST ast = expression_AST_in;
        Expression lhs = null;
        Expression rhs = null;
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                if (_t == null) {
                    _t = TreeParser.ASTNULL;
                }
                switch (_t.getType()) {
                    case 14: {
                        AST __t116 = _t;
                        SelectorAST tmp10_AST_in = (SelectorAST)_t;
                        this.match(_t, 14);
                        _t = _t.getFirstChild();
                        plusl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        plusr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t116;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), plusl, plusr, Type.NUMERIC);
                        break;
                    }
                    case 15: {
                        AST __t117 = _t;
                        SelectorAST tmp11_AST_in = (SelectorAST)_t;
                        this.match(_t, 15);
                        _t = _t.getFirstChild();
                        minusl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        minusr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t117;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), minusl, minusr, Type.NUMERIC);
                        break;
                    }
                    case 16: {
                        AST __t118 = _t;
                        SelectorAST tmp12_AST_in = (SelectorAST)_t;
                        this.match(_t, 16);
                        _t = _t.getFirstChild();
                        multl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        multr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t118;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), multl, multr, Type.NUMERIC);
                        break;
                    }
                    case 17: {
                        AST __t119 = _t;
                        SelectorAST tmp13_AST_in = (SelectorAST)_t;
                        this.match(_t, 17);
                        _t = _t.getFirstChild();
                        divl = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        lhs = this.expression(_t);
                        _t = this._retTree;
                        divr = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                        rhs = this.expression(_t);
                        _t = this._retTree;
                        _t = __t119;
                        _t = _t.getNextSibling();
                        TypeChecker.check(ast.getText(), divl, divr, Type.NUMERIC);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                expr = this._factory.binaryOperator(ast.getType(), lhs, rhs);
                break;
            }
            case 4: 
            case 18: 
            case 20: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                expr = this.term(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return expr;
    }

    public final Expression booleanExpression(AST _t) throws RecognitionException {
        SelectorAST booleanExpression_AST_in = (SelectorAST)_t;
        Expression expr = null;
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 21: {
                expr = this.isExpression(_t);
                _t = this._retTree;
                break;
            }
            case 23: {
                expr = this.betweenExpression(_t);
                _t = this._retTree;
                break;
            }
            case 25: {
                expr = this.likeExpression(_t);
                _t = this._retTree;
                break;
            }
            case 24: {
                expr = this.inExpression(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return expr;
    }

    public final Expression term(AST _t) throws RecognitionException {
        SelectorAST term_AST_in = (SelectorAST)_t;
        SelectorAST ident = null;
        Expression expr = null;
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 4: {
                AST __t134 = _t;
                SelectorAST tmp14_AST_in = (SelectorAST)_t;
                this.match(_t, 4);
                _t = _t.getFirstChild();
                expr = this.unaryTerm(_t);
                _t = this._retTree;
                _t = __t134;
                _t = _t.getNextSibling();
                break;
            }
            case 18: {
                SelectorAST tmp15_AST_in = (SelectorAST)_t;
                this.match(_t, 18);
                _t = _t.getNextSibling();
                expr = this.primaryExpression(_t);
                _t = this._retTree;
                SelectorAST tmp16_AST_in = (SelectorAST)_t;
                this.match(_t, 19);
                _t = _t.getNextSibling();
                break;
            }
            case 20: {
                ident = (SelectorAST)_t;
                this.match(_t, 20);
                _t = _t.getNextSibling();
                expr = this._factory.identifier(ident.getText());
                break;
            }
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                expr = this.literal(_t);
                _t = this._retTree;
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return expr;
    }

    public final Expression isExpression(AST _t) throws RecognitionException {
        SelectorAST isExpression_AST_in = (SelectorAST)_t;
        SelectorAST id = null;
        Expression expr = null;
        AST __t122 = _t;
        SelectorAST tmp17_AST_in = (SelectorAST)_t;
        this.match(_t, 21);
        _t = _t.getFirstChild();
        id = (SelectorAST)_t;
        this.match(_t, 20);
        _t = _t.getNextSibling();
        SelectorAST tmp18_AST_in = (SelectorAST)_t;
        this.match(_t, 22);
        _t = _t.getNextSibling();
        _t = __t122;
        _t = _t.getNextSibling();
        Expression ident = this._factory.identifier(id.getText());
        expr = this._factory.isNull(ident);
        this._retTree = _t;
        return expr;
    }

    public final Expression betweenExpression(AST _t) throws RecognitionException {
        SelectorAST betweenExpression_AST_in = (SelectorAST)_t;
        SelectorAST e = null;
        SelectorAST s1 = null;
        SelectorAST s2 = null;
        Expression expr = null;
        Expression sum1 = null;
        Expression sum2 = null;
        AST __t124 = _t;
        SelectorAST tmp19_AST_in = (SelectorAST)_t;
        this.match(_t, 23);
        _t = _t.getFirstChild();
        e = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
        expr = this.primaryExpression(_t);
        _t = this._retTree;
        s1 = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
        sum1 = this.primaryExpression(_t);
        _t = this._retTree;
        s2 = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
        sum2 = this.primaryExpression(_t);
        _t = this._retTree;
        _t = __t124;
        _t = _t.getNextSibling();
        TypeChecker.check(e, Type.NUMERIC);
        TypeChecker.check(s1, Type.NUMERIC);
        TypeChecker.check(s2, Type.NUMERIC);
        expr = this._factory.between(expr, sum1, sum2);
        this._retTree = _t;
        return expr;
    }

    public final Expression likeExpression(AST _t) throws RecognitionException {
        SelectorAST likeExpression_AST_in = (SelectorAST)_t;
        SelectorAST id = null;
        SelectorAST pat = null;
        SelectorAST esc = null;
        Expression expr = null;
        AST __t126 = _t;
        SelectorAST tmp20_AST_in = (SelectorAST)_t;
        this.match(_t, 25);
        _t = _t.getFirstChild();
        id = (SelectorAST)_t;
        this.match(_t, 20);
        _t = _t.getNextSibling();
        pat = (SelectorAST)_t;
        this.match(_t, 26);
        _t = _t.getNextSibling();
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 27: {
                SelectorAST tmp21_AST_in = (SelectorAST)_t;
                this.match(_t, 27);
                _t = _t.getNextSibling();
                esc = (SelectorAST)_t;
                this.match(_t, 26);
                _t = _t.getNextSibling();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        _t = __t126;
        _t = _t.getNextSibling();
        TypeChecker.check(id, Type.STRING);
        PatternValidator.validate(pat, esc);
        Expression ident = this._factory.identifier(id.getText());
        String escape = esc != null ? esc.getText() : null;
        expr = this._factory.like(ident, pat.getText(), escape);
        this._retTree = _t;
        return expr;
    }

    public final Expression inExpression(AST _t) throws RecognitionException {
        SelectorAST inExpression_AST_in = (SelectorAST)_t;
        SelectorAST id = null;
        Expression expr = null;
        AST __t129 = _t;
        SelectorAST tmp22_AST_in = (SelectorAST)_t;
        this.match(_t, 24);
        _t = _t.getFirstChild();
        id = (SelectorAST)_t;
        this.match(_t, 20);
        _t = _t.getNextSibling();
        SelectorAST tmp23_AST_in = (SelectorAST)_t;
        this.match(_t, 18);
        _t = _t.getNextSibling();
        HashSet set = this.valueList(_t);
        _t = this._retTree;
        SelectorAST tmp24_AST_in = (SelectorAST)_t;
        this.match(_t, 19);
        _t = _t.getNextSibling();
        _t = __t129;
        _t = _t.getNextSibling();
        TypeChecker.check(id, Type.STRING);
        Expression ident = this._factory.identifier(id.getText());
        expr = this._factory.in(ident, set);
        this._retTree = _t;
        return expr;
    }

    public final HashSet valueList(AST _t) throws RecognitionException {
        SelectorAST valueList_AST_in = (SelectorAST)_t;
        SelectorAST first = null;
        SelectorAST next = null;
        HashSet<String> set = new HashSet<String>();
        first = (SelectorAST)_t;
        this.match(_t, 26);
        _t = _t.getNextSibling();
        set.add(first.getText());
        while (true) {
            if (_t == null) {
                _t = TreeParser.ASTNULL;
            }
            if (_t.getType() != 26) break;
            next = (SelectorAST)_t;
            this.match(_t, 26);
            _t = _t.getNextSibling();
            set.add(next.getText());
        }
        this._retTree = _t;
        return set;
    }

    public final Expression unaryTerm(AST _t) throws RecognitionException {
        SelectorAST unaryTerm_AST_in = (SelectorAST)_t;
        SelectorAST minus = null;
        SelectorAST term = null;
        SelectorAST primary = null;
        Expression expr = null;
        SelectorAST ast = unaryTerm_AST_in;
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 4: {
                AST __t136 = _t;
                minus = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                this.match(_t, 4);
                _t = _t.getFirstChild();
                term = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                expr = this.term(_t);
                _t = this._retTree;
                _t = __t136;
                _t = _t.getNextSibling();
                TypeChecker.check(ast.getText(), term, Type.NUMERIC);
                break;
            }
            case 18: {
                SelectorAST tmp25_AST_in = (SelectorAST)_t;
                this.match(_t, 18);
                _t = _t.getNextSibling();
                primary = _t == TreeParser.ASTNULL ? null : (SelectorAST)_t;
                expr = this.primaryExpression(_t);
                _t = this._retTree;
                SelectorAST tmp26_AST_in = (SelectorAST)_t;
                this.match(_t, 19);
                _t = _t.getNextSibling();
                TypeChecker.check(primary.getText(), primary, Type.NUMERIC);
                expr = this._factory.unaryOperator(4, expr);
                break;
            }
            case 20: {
                SelectorAST tmp27_AST_in = (SelectorAST)_t;
                this.match(_t, 20);
                _t = _t.getNextSibling();
                expr = this._factory.identifier(ast.getText());
                TypeChecker.check(ast.getText(), ast, Type.NUMERIC);
                expr = this._factory.unaryOperator(4, expr);
                break;
            }
            case 29: 
            case 30: {
                if (_t == null) {
                    _t = TreeParser.ASTNULL;
                }
                switch (_t.getType()) {
                    case 29: {
                        SelectorAST tmp28_AST_in = (SelectorAST)_t;
                        this.match(_t, 29);
                        _t = _t.getNextSibling();
                        break;
                    }
                    case 30: {
                        SelectorAST tmp29_AST_in = (SelectorAST)_t;
                        this.match(_t, 30);
                        _t = _t.getNextSibling();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(_t);
                    }
                }
                expr = this._factory.literal(ast.getType(), "-" + ast.getText());
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        this._retTree = _t;
        return expr;
    }

    public final Expression literal(AST _t) throws RecognitionException {
        SelectorAST literal_AST_in = (SelectorAST)_t;
        Expression expr = null;
        SelectorAST ast = literal_AST_in;
        if (_t == null) {
            _t = TreeParser.ASTNULL;
        }
        switch (_t.getType()) {
            case 29: {
                SelectorAST tmp30_AST_in = (SelectorAST)_t;
                this.match(_t, 29);
                _t = _t.getNextSibling();
                break;
            }
            case 30: {
                SelectorAST tmp31_AST_in = (SelectorAST)_t;
                this.match(_t, 30);
                _t = _t.getNextSibling();
                break;
            }
            case 26: {
                SelectorAST tmp32_AST_in = (SelectorAST)_t;
                this.match(_t, 26);
                _t = _t.getNextSibling();
                break;
            }
            case 31: {
                SelectorAST tmp33_AST_in = (SelectorAST)_t;
                this.match(_t, 31);
                _t = _t.getNextSibling();
                break;
            }
            case 32: {
                SelectorAST tmp34_AST_in = (SelectorAST)_t;
                this.match(_t, 32);
                _t = _t.getNextSibling();
                break;
            }
            default: {
                throw new NoViableAltException(_t);
            }
        }
        expr = this._factory.literal(ast.getType(), ast.getText());
        this._retTree = _t;
        return expr;
    }
}

